package com.reyun.controller;

import java.util.List;
import java.util.Map;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.reyun.model.Account;
import com.reyun.security.annotation.CurrentAccount;
import com.reyun.service.FunnelService;
import com.reyun.util.ResultModel;
import com.reyun.util.ResultStatus;
import com.reyun.util.StringUtil;

@Controller
@RequestMapping("/funnel")
public class FunnelController {
	protected Logger logger = LoggerFactory
			.getLogger(FunnelController.class);

	@Autowired
	FunnelService funnelService;
	
	


	@RequestMapping(value = "find/{app}", method = RequestMethod.GET)
	@ResponseBody
	public ResultModel list(HttpServletRequest request,
			@CurrentAccount Account account, @PathVariable Long app) {
		return ResultModel.OK(funnelService.findByApp(app));
	}
	
	@RequestMapping(value = "report/{funnel}", method = RequestMethod.GET)
	@ResponseBody
	public ResultModel reportChart(HttpServletRequest request,
			@PathVariable Long funnel, @CurrentAccount Account loginAccount) {
		String startDate = request.getParameter("startdate");
		String endDate = request.getParameter("enddate");
		String usergroupStr = request.getParameter("usergroupid");
		String dimentionStr = request.getParameter("dimention");
		boolean isList = request.getParameter("datatype")==null?false:"list".equals(request.getParameter("datatype"))?true:false;
		String isDeviceStr = request.getParameter("isdevice");
		String eventType = request.getParameter("eventType");
		boolean isProfile=false;
		if(!StringUtils.isEmpty(eventType) && "profile".equals(eventType)){
			isProfile=true;
		}
		boolean isDevice = StringUtil.isEmpty(isDeviceStr)?false:"true".equals(isDeviceStr)?true:false;
		Map<String, List> result = funnelService.funnelReport(funnel, startDate, endDate, usergroupStr, isList, dimentionStr, loginAccount, isDevice,isProfile);
		
		if (result.isEmpty()) {
			return ResultModel.ERROR(ResultStatus.NETWORK_ERROR);
		} else {
			return ResultModel.OK(result);
		}
	}

}
