package com.reyun.controller;

import com.reyun.model.Account;
import com.reyun.model.UserNoticeLog;
import com.reyun.security.annotation.CurrentAccount;
import com.reyun.service.NoticeService;
import com.reyun.util.ResultModel;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.util.Date;

/**
 * Created by sunhao on 17/3/1.
 * description:公告查询
 */
@Controller
@RequestMapping("notice")
public class NoticeController {

    @Autowired
    private NoticeService noticeService;

    @RequestMapping(value = "findDeploy", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel listRecentDeployNotice(@CurrentAccount Account account) {

        return ResultModel.OK(noticeService.listRecentDeployNotice(account.getId()));
    }

    @RequestMapping(value = "saveReadLog/{noticeId}", method = RequestMethod.POST)
    @ResponseBody
    public ResultModel saveUserNoticeReadLog(@PathVariable Long noticeId, @CurrentAccount Account account) {

        return ResultModel.OK(noticeService.saveReadLog(new UserNoticeLog(noticeId, account.getId(), new Date())));

    }
}
