package com.reyun.controller;



import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.reyun.service.ProfileService;
import com.reyun.util.ResultModel;

@Controller
@RequestMapping("/{appid}/profile")
public class ProfileController {
	
	protected Logger logger = LoggerFactory.getLogger(ProfileController.class);
	
	@Autowired
	ProfileService profileService;
	
	
	
	@RequestMapping(value = "/find", method = RequestMethod.GET)
	@ResponseBody
	public ResultModel findAll(HttpServletRequest request,
			@PathVariable Long appid) {

		return ResultModel.OK(this.profileService.listAllByAppkey(appid));
	}
	

}
