package com.reyun.controller.manage;

import com.reyun.dic.LogEnumType;
import com.reyun.dic.OperateObjectEnumType;
import com.reyun.exception.TipException;
import com.reyun.model.*;
import com.reyun.security.annotation.CurrentAccount;
import com.reyun.service.EventService;
import com.reyun.service.UserLogService;
import com.reyun.util.ResultModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.List;

@Controller
@RequestMapping("/mng/event")
public class MngEventController {
    protected Logger logger = LoggerFactory.getLogger(MngEventController.class);

    @Autowired
    EventService eventService;

    @Autowired
    UserLogService userLogService;

    @RequestMapping(value = "find/{app}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel list(@CurrentAccount Account account, @PathVariable Long app) {

        List<Event4Web> event4Webs = eventService.listEvent(app);
        userLogService.insertLog(account, LogEnumType.FIND.getCode(), LogEnumType.FIND.getName() + "事件列表",
                null, app, OperateObjectEnumType.EVENT.getCode());
        return ResultModel.OK(event4Webs);
    }

    @RequestMapping(value = "find/one/{app}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel listone(@CurrentAccount Account account, @RequestParam(required = false) String name, @PathVariable Long app) {

        List<EventAttr4Web> eventAttr4Webs = eventService.listOneEvent(app, name);
        userLogService.insertLog(account, LogEnumType.FIND.getCode(), LogEnumType.FIND.getName() + "事件属性列表" + name,
                null, app, OperateObjectEnumType.EVENT.getCode());
        return ResultModel.OK(eventAttr4Webs);
    }

    @RequestMapping(value = "update/{app}", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel update(@RequestBody EventMeta event, @CurrentAccount Account account, @PathVariable Long app) {

        EventMeta updateEvent = eventService.updateEvent(app,event.getEventId(), event.getAlias(), account.getId());
        userLogService.insertLog(account, LogEnumType.UPDATE.getCode(), LogEnumType.UPDATE.getName() + "事件" + event.getEventId(),
                null, app, OperateObjectEnumType.EVENT.getCode());
        return ResultModel.OK(updateEvent);
    }

    @RequestMapping(value = "update/{app}/one", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel updateOne(@RequestBody EventAttributeMeta attr, @CurrentAccount Account account, @PathVariable Long app) {

        EventAttributeMeta eventAttributeMeta = eventService.updateEventAttr(attr.getAttribute(), attr.getAlias(), account.getId(), app);
        userLogService.insertLog(account, LogEnumType.UPDATE.getCode(), LogEnumType.UPDATE.getName() + "事件属性" + attr.getAttribute(),
                null, null, OperateObjectEnumType.EVENT.getCode());

        return ResultModel.OK(eventAttributeMeta);
    }

    @RequestMapping(value = "enable/{app}", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel enableEvent(@PathVariable Long app, @RequestBody EventMeta event, @CurrentAccount Account account) {

        try {
            eventService.enableEvent(app, event.getEventId(), account.getId());
            userLogService.insertLog(account, LogEnumType.UPDATE.getCode(), "启用事件" + event.getEventId(),
                    null, app, OperateObjectEnumType.EVENT.getCode());
        } catch (Exception e) {
            logger.error("授权失败", e);
            throw new TipException("授权失败");
        }

        return ResultModel.OK();
    }

    @RequestMapping(value = "forbidden/{app}", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel forbiddenEvent(@PathVariable Long app, @RequestBody EventMeta event, @CurrentAccount Account account) {

        try {
            eventService.forbiddenEvent(app, event.getEventId(), account.getId());
            userLogService.insertLog(account, LogEnumType.UPDATE.getCode(), "停用事件" + event.getEventId(),
                    null, app, OperateObjectEnumType.EVENT.getCode());
        } catch (Exception e) {
            logger.error("授权失败", e);
            throw new TipException("授权失败");
        }

        return ResultModel.OK();
    }

    @RequestMapping(value = "enable/attr/{app}", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel enable(@PathVariable Long app, @CurrentAccount Account account,@RequestBody EventAttributeMeta attr) {

        try {
            EventAttributeMeta eventAttributeMeta = eventService.enableAttr(app, attr.getAttribute(), account.getId());
            userLogService.insertLog(account, LogEnumType.UPDATE.getCode(), "启用事件属性" + attr.getAttribute(), null,
                    null, OperateObjectEnumType.EVENT.getCode());
        } catch (Exception e) {
            logger.error("授权失败", e);
            throw new TipException("授权失败");
        }

        return ResultModel.OK();
    }

    @RequestMapping(value = "forbidden/attr/{app}", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel forbidden(@PathVariable Long app, @CurrentAccount Account account,@RequestBody EventAttributeMeta attr) {

        try {
            eventService.forbiddenAttr(app, attr.getAttribute(), account.getId());
            userLogService.insertLog(account, LogEnumType.UPDATE.getCode(), "停用事件属性" + attr.getAttribute(), null,
                    null, OperateObjectEnumType.EVENT.getCode());
        } catch (Exception e) {
            logger.error("授权失败", e);
            throw new TipException("授权失败");
        }

        return ResultModel.OK();
    }

    /**
     * 加入事件分析显示属性
     * created by sunhao 2017-04-13
     */
    @RequestMapping(value = "addStats/{appId}", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel addEventAddStats(@CurrentAccount Account account, @PathVariable Long appId,
                                        @RequestBody EventAttributeMeta attr) {

        return ResultModel.OK(eventService.updateEventStatsView(appId, account.getId(), attr.getAttribute(), true));
    }

    /**
     * 移除事件分析显示属性
     * created by sunhao 2017-04-13
     */
    @RequestMapping(value = "delStats/{appId}", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel deleteEventAddStats(@CurrentAccount Account account, @PathVariable Long appId,
                                           @RequestBody EventAttributeMeta attr) {

        return ResultModel.OK(eventService.updateEventStatsView(appId, account.getId(), attr.getAttribute(), false));
    }

    /**
     * 加入事件分析属性条件列表
     * created by sunhao 2017-04-18
     */
    @RequestMapping(value = "addCondition/{appId}", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel addEventAttrAddCondition(@CurrentAccount Account account, @PathVariable Long appId,
                                                @RequestBody EventAttributeMeta attr) {

        return ResultModel.OK(eventService.updateEventStatsCondition(appId, account.getId(), attr.getAttribute(), true));
    }

    /**
     * 移除事件分析属性条件列表
     * created by sunhao 2017-04-18
     */
    @RequestMapping(value = "delCondition/{appId}", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel deleteEventAttrAddCondition(@CurrentAccount Account account, @PathVariable Long appId,
                                                   @RequestBody EventAttributeMeta attr) {

        return ResultModel.OK(eventService.updateEventStatsCondition(appId, account.getId(), attr.getAttribute(), false));
    }
}
