package com.reyun.controller.manage;

import com.reyun.dic.LogEnumType;
import com.reyun.dic.OperateObjectEnumType;
import com.reyun.model.Account;
import com.reyun.model.EventStats;
import com.reyun.security.annotation.CurrentAccount;
import com.reyun.service.EventStatsService;
import com.reyun.service.UserLogService;
import com.reyun.util.ResultModel;
import com.reyun.util.ResultStatus;
import com.reyun.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.Date;
import java.util.List;

/**
 * Created by sunhao on 17/4/10.
 * description:增删改查事件分析的条件
 */
@Controller
@RequestMapping("/mng/eventstats")
public class MngEventStatsController {

    protected Logger logger = LoggerFactory.getLogger(MngEventStatsController.class);

    @Autowired
    private EventStatsService eventStatsService;
    @Autowired
    private UserLogService userLogService;


    @RequestMapping(value = "checkName/{appId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel validateEventStatsName(@CurrentAccount Account account, @RequestParam String eventStatsName,@PathVariable Long appId){
        return ResultModel.OK(eventStatsService.checkEventStatsName(eventStatsName,appId));
    }

    @RequestMapping(value = "create", method = RequestMethod.POST)
    @ResponseBody
    public ResultModel createEventStats(@CurrentAccount Account account, @RequestBody EventStats eventStats) {

        EventStats eventStatsResult = null;

        //校验参数
        if (null != eventStats.getApp() && !StringUtil.isEmpty(eventStats.getEventCondition())
                && !StringUtil.isEmpty(eventStats.getEventName()) && !StringUtil.isEmpty(eventStats.getName())) {

            //创建和修改用户时间填充
            Date createDate = new Date();
            eventStats.setCreateAccount(account.getId());
            eventStats.setCreateTime(createDate);
            eventStats.setModifyAccount(account.getId());
            eventStats.setModifyTime(createDate);
            eventStats.setComplicatedEvents(false);
            eventStats.setValid(true);

            //保存
            eventStatsResult = eventStatsService.createEventStats(eventStats);

            //记录日志
            userLogService.insertLog(account, LogEnumType.CREATE.getCode(), LogEnumType.CREATE.getName() + "事件分析",
                    eventStats, eventStats.getApp(), OperateObjectEnumType.EVENT_STATS.getCode());
        }

        return ResultModel.OK(eventStatsResult);
    }

    @RequestMapping(value = "findAll/{appId}", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel getAllEventStats(@CurrentAccount Account account, @PathVariable Long appId) {

        List<EventStats> eventStatsList = eventStatsService.findAllEventStats(account.getId(), appId);
        //记录日志
        userLogService.insertLog(account, LogEnumType.FIND.getCode(), LogEnumType.FIND.getName() + "事件分析列表",
                null, appId, OperateObjectEnumType.EVENT_STATS.getCode());

        return ResultModel.OK(eventStatsList);
    }

    @RequestMapping(value = "update", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel updateEventStats(@CurrentAccount Account account, @RequestBody EventStats eventStats) {

        if (null != eventStats.getId() && !StringUtil.isEmpty(eventStats.getEventCondition())) {

            int result = eventStatsService.updateEventStats(eventStats, account.getId());
            //记录日志
            userLogService.insertLog(account, LogEnumType.UPDATE.getCode(), LogEnumType.UPDATE.getName() + "事件分析" + eventStats.getName(),
                    eventStats, null, OperateObjectEnumType.EVENT_STATS.getCode());

            return ResultModel.OK(result);

        } else {

            return ResultModel.ERROR(ResultStatus.PARAM_INVALID);
        }

    }

    @RequestMapping(value = "delete/{eventStatsId}", method = RequestMethod.DELETE)
    @ResponseBody
    public ResultModel deleteEventStats(@CurrentAccount Account account, @PathVariable Long eventStatsId) {

        int result = eventStatsService.deleteEventStats(eventStatsId, account.getId());
        //记录日志
        userLogService.insertLog(account, LogEnumType.DELETE.getCode(), LogEnumType.DELETE.getName() + "事件分析" + eventStatsId,
                null, eventStatsId, OperateObjectEnumType.EVENT_STATS.getCode());

        return ResultModel.OK(result);
    }

}
