package com.reyun.controller.manage;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.reyun.dic.LogEnumType;
import com.reyun.dic.OperateObjectEnumType;
import com.reyun.model.Account;
import com.reyun.model.Funnel;
import com.reyun.security.annotation.CurrentAccount;
import com.reyun.service.FunnelService;
import com.reyun.service.UserLogService;
import com.reyun.util.ResultModel;

@Controller
@RequestMapping("/mng/funnel")
public class MngFunnelController {
	protected Logger logger = LoggerFactory
			.getLogger(MngFunnelController.class);

	@Autowired
	FunnelService funnelService;
	
	@Autowired
	UserLogService userLogService;

	@RequestMapping(value = "create", method = RequestMethod.POST)
	@ResponseBody
	public ResultModel create(HttpServletRequest request,
			@RequestBody Funnel funnel, @CurrentAccount Account account) {
		Funnel result = funnelService.create(funnel, account.getId());
		userLogService.insertLog(account, LogEnumType.CREATE.getCode(), LogEnumType.CREATE.getName() + "漏斗" + result.getName(), result,null,OperateObjectEnumType.FUNNEL.getCode());
		return ResultModel.OK(result);
	}

	@RequestMapping(value = "update", method = RequestMethod.PUT)
	@ResponseBody
	public ResultModel update(HttpServletRequest request,
			@RequestBody Funnel funnel, @CurrentAccount Account account) {
		Funnel result = funnelService.update(funnel, account.getId());
		userLogService.insertLog(account, LogEnumType.UPDATE.getCode(), LogEnumType.UPDATE.getName() + "漏斗" + result.getName(), result,null,OperateObjectEnumType.FUNNEL.getCode());
		return ResultModel.OK(result);
	}

	@RequestMapping(value = "delete/{id}", method = RequestMethod.DELETE)
	@ResponseBody
	public ResultModel delete(HttpServletRequest request,
			@PathVariable Long id, @CurrentAccount Account account) {
		Funnel result = funnelService.delete(id, account.getId());
		userLogService.insertLog(account, LogEnumType.DELETE.getCode(), LogEnumType.DELETE.getName() + "漏斗" + result.getName(), result,null,OperateObjectEnumType.FUNNEL.getCode());

		return ResultModel.OK();
	}

	@RequestMapping(value = "find/{app}", method = RequestMethod.GET)
	@ResponseBody
	public ResultModel list(HttpServletRequest request,
			@CurrentAccount Account account, @PathVariable Long app) {
		userLogService.insertLog(account, LogEnumType.FIND.getCode(), LogEnumType.FIND.getName() + "漏斗列表", null,null,OperateObjectEnumType.FUNNEL.getCode());
		return ResultModel.OK(funnelService.findByApp(app));
	}

	@RequestMapping(value = "valid/{app}", method = RequestMethod.GET)
	@ResponseBody
	public ResultModel check(@RequestParam String name, @PathVariable Long app) {
		Funnel dbFunnel = funnelService.validName(name, app);
		if (dbFunnel == null) {
			return ResultModel.OK(false);
		} else {
			return ResultModel.OK(true);
		}
	}
}
