package com.reyun.controller.manage;

import javax.servlet.http.HttpServletRequest;

import com.reyun.model.EventAttributeMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import com.reyun.dic.LogEnumType;
import com.reyun.dic.OperateObjectEnumType;
import com.reyun.exception.TipException;
import com.reyun.model.Account;
import com.reyun.model.Profile;
import com.reyun.security.annotation.CurrentAccount;
import com.reyun.service.ProfileService;
import com.reyun.service.UserLogService;
import com.reyun.util.ResultModel;

@Controller
@RequestMapping("/mng/profile")
public class MngProfileController
{

    protected Logger logger = LoggerFactory.getLogger(MngProfileController.class);

    @Autowired
    ProfileService profileService;

    @Autowired
    UserLogService userLogService;

    @RequestMapping(value = "{appid}/find", method = RequestMethod.GET)
    @ResponseBody
    public ResultModel findAll(HttpServletRequest request,
            @PathVariable Long appid, @CurrentAccount Account loginAccount)
    {
        userLogService.insertLog(loginAccount, LogEnumType.FIND.getCode(), LogEnumType.FIND.getName() + "属性列表", null, appid, OperateObjectEnumType.PROFILE.getCode());
        return ResultModel.OK(this.profileService.listByAppkey(appid));
    }

    @RequestMapping(value = "/update", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel update(HttpServletRequest request, @RequestBody Profile resource, @CurrentAccount Account loginAccount)
    {
        Profile result = this.profileService.update(resource, loginAccount.getId());
        userLogService.insertLog(loginAccount, LogEnumType.UPDATE.getCode(), LogEnumType.UPDATE.getName() + "属性" + result.getAttr(), result, null, OperateObjectEnumType.PROFILE.getCode());
        return ResultModel.OK(result);
    }

    @RequestMapping(value = "addCondition/{appId}/{attr}", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel addProfileAttrAddCondition(@CurrentAccount Account account, @PathVariable Long appId,@PathVariable String attr) {
        return ResultModel.OK(this.profileService.updateProfileStatsCondition(appId,attr,true));
    }

    @RequestMapping(value = "delCondition/{appId}/{attr}", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel delProfileAttrAddCondition(@CurrentAccount Account account, @PathVariable Long appId,@PathVariable String attr) {
        return ResultModel.OK(this.profileService.updateProfileStatsCondition(appId,attr,false));
    }


    @RequestMapping(value = "enable/{appkey}/{attr}", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel enable(HttpServletRequest request,
            @PathVariable String appkey, @PathVariable String attr, @CurrentAccount Account currentAccount)
    {

        try {
            Profile result = this.profileService.enable(appkey, attr, currentAccount.getId());
            userLogService.insertLog(currentAccount, LogEnumType.UPDATE.getCode(), LogEnumType.UPDATE.getName() + "属性授权" + result.getAttr(), result, null, OperateObjectEnumType.PROFILE.getCode());
        }
        catch (Exception e) {
            logger.error("授权失败", e);
            throw new TipException("授权失败");
        }
        return ResultModel.OK();
    }

    @RequestMapping(value = "forbidden/{appkey}/{attr}", method = RequestMethod.PUT)
    @ResponseBody
    public ResultModel forbidden(HttpServletRequest request,
            @PathVariable String appkey, @PathVariable String attr, @CurrentAccount Account currentAccount)
    {

        try {
            Profile result = this.profileService.forbidden(appkey, attr, currentAccount.getId());
            userLogService.insertLog(currentAccount, LogEnumType.UPDATE.getCode(), LogEnumType.UPDATE.getName() + "属性收回授权" + result.getAttr(), result, null, OperateObjectEnumType.PROFILE.getCode());
        }
        catch (Exception e) {
            logger.error("授权失败", e);
            throw new TipException("授权失败");
        }
        return ResultModel.OK();
    }




}
