package com.reyun.controller.manage;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.reyun.dic.LogEnumType;
import com.reyun.dic.OperateObjectEnumType;
import com.reyun.model.Account;
import com.reyun.model.Retention;
import com.reyun.security.annotation.CurrentAccount;
import com.reyun.service.RetentionService;
import com.reyun.service.UserLogService;
import com.reyun.util.ResultModel;

@Controller
@RequestMapping("/mng/retention")
public class MngRetentionController {
	protected Logger logger = LoggerFactory
			.getLogger(MngRetentionController.class);

	@Autowired
	RetentionService retentionService;
	
	@Autowired
	UserLogService userLogService;

	@RequestMapping(value = "create", method = RequestMethod.POST)
	@ResponseBody
	public ResultModel create(HttpServletRequest request,
			@RequestBody Retention retention, @CurrentAccount Account account) {
		Retention create = retentionService.create(retention, account.getId());
		userLogService.insertLog(account, LogEnumType.CREATE.getCode(), LogEnumType.CREATE.getName() + "留存" + create.getName() , create,create.getApp(),OperateObjectEnumType.RETENTION.getCode());
		return ResultModel.OK(create);
	}

	@RequestMapping(value = "update", method = RequestMethod.PUT)
	@ResponseBody
	public ResultModel update(HttpServletRequest request,
			@RequestBody Retention retention, @CurrentAccount Account account) {
		Retention update = retentionService.update(retention, account.getId());
		userLogService.insertLog(account, LogEnumType.UPDATE.getCode(), LogEnumType.UPDATE.getName() + "留存" + update.getName() , update,update.getApp(),OperateObjectEnumType.RETENTION.getCode());
		return ResultModel.OK();
	}

	@RequestMapping(value = "delete/{id}", method = RequestMethod.DELETE)
	@ResponseBody
	public ResultModel delete(HttpServletRequest request,
			@PathVariable Long id, @CurrentAccount Account account) {
		Retention delete = retentionService.delete(id, account.getId());
		userLogService.insertLog(account, LogEnumType.DELETE.getCode(), LogEnumType.DELETE.getName() + "留存" + delete.getName() , delete,delete.getApp(),OperateObjectEnumType.RETENTION.getCode());
		return ResultModel.OK(delete);
	}

	@RequestMapping(value = "find/{app}", method = RequestMethod.GET)
	@ResponseBody
	public ResultModel list(HttpServletRequest request,
			@CurrentAccount Account account, @PathVariable Long app) {
		List<Retention> findByApp = retentionService.findByApp(app);
		userLogService.insertLog(account, LogEnumType.FIND.getCode(), LogEnumType.FIND.getName() + "留存列表"  , null,app,OperateObjectEnumType.RETENTION.getCode());
		return ResultModel.OK(findByApp);
	}

	@RequestMapping(value = "valid/{app}", method = RequestMethod.GET)
	@ResponseBody
	public ResultModel check(@RequestParam String name, @PathVariable Long app) {
		Retention retention = retentionService.validName(name, app);
		if (retention == null) {
			return ResultModel.OK(false);
		} else {
			return ResultModel.OK(true);
		}
	}
}
