package com.reyun.controller.manage;

import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.reyun.dic.LogEnumType;
import com.reyun.dic.OperateObjectEnumType;
import com.reyun.exception.TipException;
import com.reyun.model.Account;
import com.reyun.model.UserGroup;
import com.reyun.security.annotation.CurrentAccount;
import com.reyun.service.UserGroupService;
import com.reyun.service.UserLogService;
import com.reyun.util.ResultModel;

@Controller
@RequestMapping("/mng/usergroup")
public class MngUserGroupController {
	protected Logger logger = LoggerFactory
			.getLogger(MngUserGroupController.class);

	@Autowired
	UserGroupService userGroupService;

	@Autowired
	UserLogService userLogService;

	@RequestMapping(value = "create", method = RequestMethod.POST)
	@ResponseBody
	public ResultModel create(HttpServletRequest request,
			@RequestBody UserGroup userGroup, @CurrentAccount Account account) {
		try {

			UserGroup save = userGroupService.save(userGroup, account.getId());
			userLogService.insertLog(account, LogEnumType.CREATE.getCode(), LogEnumType.CREATE.getName() + "用户群" + save.getName(), save,save.getApp(),OperateObjectEnumType.USER_GROUP.getCode());
		} catch (Exception e) {
			logger.error("授权失败", e);
			throw new TipException("授权失败");
		}
		return ResultModel.OK();
	}

	@RequestMapping(value = "update", method = RequestMethod.PUT)
	@ResponseBody
	public ResultModel update(HttpServletRequest request,
			@RequestBody UserGroup userGroup, @CurrentAccount Account account) {
		try {

			UserGroup save = userGroupService.update(userGroup, account.getId());
			userLogService.insertLog(account, LogEnumType.UPDATE.getCode(), LogEnumType.UPDATE.getName() + "用户群" + save.getName(), save,save.getApp(),OperateObjectEnumType.USER_GROUP.getCode());
		} catch (Exception e) {
			logger.error("授权失败", e);
			throw new TipException("授权失败");
		}
		return ResultModel.OK();
	}
	
	@RequestMapping(value = "refresh/{id}", method = RequestMethod.PUT)
	@ResponseBody
	public ResultModel refresh(HttpServletRequest request,
			@PathVariable Long id) {
		boolean flag = false;
		try {

			flag = userGroupService.refresh(id);

		} catch (Exception e) {
			logger.error("授权失败", e);
			throw new TipException("授权失败");
		}
		return ResultModel.OK(flag);
	}

	@RequestMapping(value = "delete/{id}", method = RequestMethod.DELETE)
	@ResponseBody
	public ResultModel delete(HttpServletRequest request,
			@PathVariable Long id, @CurrentAccount Account account) {
		try {

			UserGroup save = userGroupService.delete(id, account.getId());
			userLogService.insertLog(account, LogEnumType.DELETE.getCode(), LogEnumType.DELETE.getName() + "用户群" + save.getName(), save,save.getApp(),OperateObjectEnumType.USER_GROUP.getCode());
		} catch (Exception e) {
			logger.error("授权失败", e);
			throw new TipException("授权失败");
		}
		return ResultModel.OK();
	}

	@RequestMapping(value = "find/{app}", method = RequestMethod.GET)
	@ResponseBody
	public ResultModel list(HttpServletRequest request,
			@CurrentAccount Account account, @PathVariable Long app) {
		List<UserGroup> list = userGroupService.list(app, account.getId());
		userLogService.insertLog(account, LogEnumType.FIND.getCode(), LogEnumType.FIND.getName() + "用户群列表" , null,app,OperateObjectEnumType.USER_GROUP.getCode());
		return ResultModel.OK(list);
	}

	@RequestMapping(value = "valid/{app}", method = RequestMethod.GET)
	@ResponseBody
	public ResultModel check(@RequestParam String name,@CurrentAccount Account account,@PathVariable Long app) {
		Boolean flag = userGroupService.valid(account.getId(),app,name);
		if (!flag) {
			return ResultModel.OK(false);
		} else {
			return ResultModel.OK(true);
		}
	}
}
