package com.reyun.dic;

import com.reyun.exception.TipException;

/**
 * description:
 *
 * @author nolan
 * @date 18/10/2017
 */
public enum ChannelEnumType
{
    GDT("gdt"),
    SM("smsearch"),
    ADWORDS("adwords");

    private String uniqueName;

    ChannelEnumType(String uniqueName)
    {
        this.uniqueName = uniqueName;
    }

    public static ChannelEnumType getEnumType(String abbr)
    {
        for (ChannelEnumType channelEnumType : ChannelEnumType.values()) {
            if (channelEnumType.getUniqueName().equals(abbr)) {
                return channelEnumType;
            }
        }

        throw new TipException("[" + abbr + "]渠道枚举暂未定义");
    }

    public String getUniqueName()
    {
        return uniqueName;
    }
}
