package com.reyun.model;

import javax.persistence.*;
import java.util.Date;
import java.util.List;

@Entity
public class Account {

	private Long id;
	private String email;
	private String password;
	private String company;
	private String name;
	private String phone;
	private String qq;
	private String wechat;
	private boolean isSuperUser;
	private Long parent = 0L;
    private Long rootParent;
	private String isSpecialAccount;
	//母账号：-1表示未审核，0表示禁用，1表示已审核;子账号：0表示禁用，1表示启用;总之：1表示用户可用状态;补充：-3表示未激活 -2 表示未开通
	private int status;
	private String pastDate;
	private Date createTime = new Date();
	//审核通过的时间
	private Date pubDate;
	private Long createAccount;
	private Date modifyTime = new Date();
	private Long modifyAccount;
	private Boolean delFlag;
	private Boolean isChannelPerson;
	private String channelAccount;
    //角色ID,对应role_auth表的ID。
    private Long roleCategory;
    private Long pricelevel;
    private Long bussinessman;
    private Long activeTime;
    private Long forgetPwdTime;
    //默认状态为空 false 忘记密码邮件发送后赋值; true 修改完密码之后赋值，表示完成修改密码操作，整个忘记密码流程结束
    private Boolean forgetPwdStatus;
	//默认状态为空 false 激活邮件发送后赋值; true 激活操作之后赋值，表示完成激活操作，整个激活流程结束，防止重复提交url
	private Boolean activeStatus;
	private int appSize;
    private String remark;
    //默认为空 false 非全渠道设置参数   true全渠道设置参数
    private Boolean allChannelValidMatch;
	private Boolean allChannelFakeMatch;
	private Boolean allChannelBlackMatch;

    //Transient
    private String modifyAccountName;
    private String createAccountName;
    private String roleName;
    private Long parentRole;
    private String authStr;
    private boolean isMasterLogin;
    private List<UserLog> userLogList;
    private List<Auth> authList;
    private Boolean valid;
    private String regIpAddr;
    private String regIpLocation;
	private Boolean verifyEmail = false;
    private Boolean isFlowRestrict;
	private String modifyPricelevelTime;
	private Boolean newContract;

	public Boolean getFlowRestrict() {
		return isFlowRestrict;
	}

	public void setFlowRestrict(Boolean flowRestrict) {
		isFlowRestrict = flowRestrict;
	}


	public Account() {
		super();
	}

	public Account(Long id, String email, String password, String company,
			String name, String phone, String qq, boolean isSuperUser,
			Long parent, String isSpecialAccount, int status, String pastDate,
			Date createTime, Long createAccount, Date modifyTime,
			Long modifyAccount, boolean delFlag) {
		super();
		this.id = id;
		this.email = email;
		this.password = password;
		this.company = company;
		this.name = name;
		this.phone = phone;
		this.qq = qq;
		this.isSuperUser = isSuperUser;
		this.parent = parent;
		this.isSpecialAccount = isSpecialAccount;
		this.status = status;
		this.pastDate = pastDate;
		this.createTime = createTime;
		this.createAccount = createAccount;
		this.modifyTime = modifyTime;
		this.modifyAccount = modifyAccount;
		this.delFlag = delFlag;
	}

	@Id
	@GeneratedValue
	public Long getId() {
		return id;
	}

	public boolean getIsSuperUser() {
		return isSuperUser;
	}

	public String getName() {
		return name;
	}

	public String getPassword() {
		return password;
	}

	public String getPhone() {
		return phone;
	}

	public String getQq() {
		return qq;
	}

	public Date getCreateTime() {
		return createTime;
	}

	public void setCompany(String company) {
		this.company = company;
	}

	public void setEmail(String email) {
		this.email = email;
	}

    public String getCompany() {
        return company;
    }

    public String getEmail() {
        return email;
    }

	public void setId(Long id) {
		this.id = id;
	}

	public void setIsSuperUser(boolean isSuperUser) {
		this.isSuperUser = isSuperUser;
	}

	public void setName(String name) {
		this.name = name;
	}

	public void setPassword(String password) {
		this.password = password;
	}

	public void setPhone(String phone) {
		this.phone = phone;
	}

	public void setQq(String qq) {
		this.qq = qq;
	}

	public void setSuperUser(boolean isSuperUser) {
		this.isSuperUser = isSuperUser;
	}

	public Long getParent() {
		return parent;
	}

	public void setParent(Long parent) {
		this.parent = parent;
	}

    public Long getRootParent() {
        return rootParent;
    }

    public void setRootParent(Long rootParent) {
        this.rootParent = rootParent;
    }

    public String getIsSpecialAccount() {
		return isSpecialAccount;
	}

	public void setIsSpecialAccount(String isSpecialAccount) {
		this.isSpecialAccount = isSpecialAccount;
	}

	public int getStatus() {
		return status;
	}

	public void setStatus(int status) {
		this.status = status;
	}

	public String getPastDate() {
		return pastDate;
	}

	public void setPastDate(String pastDate) {
		this.pastDate = pastDate;
	}

	public void setCreateTime(Date createTime) {
		this.createTime = createTime;
	}

	public Long getCreateAccount() {
		return createAccount;
	}

	public void setCreateAccount(Long createAccount) {
		this.createAccount = createAccount;
	}

	public Long getModifyAccount() {
		return modifyAccount;
	}

	public void setModifyAccount(Long modifyAccount) {
		this.modifyAccount = modifyAccount;
	}

	public Date getModifyTime() {
		return modifyTime;
	}

	public void setModifyTime(Date modifyTime) {
		this.modifyTime = modifyTime;
	}

	public Boolean getDelFlag() {
		return delFlag;
	}

	public void setDelFlag(Boolean delFlag) {
		this.delFlag = delFlag;
	}

	public Boolean getIsChannelPerson() {
		return isChannelPerson;
	}

	public void setIsChannelPerson(Boolean isChannelPerson) {
		this.isChannelPerson = isChannelPerson;
	}

	public String getChannelAccount() {
		return channelAccount;
	}

	public void setChannelAccount(String channelAccount) {
		this.channelAccount = channelAccount;
	}

    public String getWechat() {
		return wechat;
	}

	public void setWechat(String wechat) {
		this.wechat = wechat;
	}

	public Long getPricelevel() {
		return pricelevel;
	}

	public void setPricelevel(Long pricelevel) {
		this.pricelevel = pricelevel;
	}

	public Long getBussinessman() {
		return bussinessman;
	}

	public void setBussinessman(Long bussinessman) {
		this.bussinessman = bussinessman;
	}

	public Date getPubDate() {
		return pubDate;
	}

	public void setPubDate(Date pubDate) {
		this.pubDate = pubDate;
	}

	public Long getActiveTime() {
		return activeTime;
	}

	public void setActiveTime(Long activeTime) {
		this.activeTime = activeTime;
	}

	public Long getForgetPwdTime() {
		return forgetPwdTime;
	}

	public void setForgetPwdTime(Long forgetPwdTime) {
		this.forgetPwdTime = forgetPwdTime;
	}

	public Boolean getForgetPwdStatus() {
		return forgetPwdStatus;
	}

	public void setForgetPwdStatus(Boolean forgetPwdStatus) {
		this.forgetPwdStatus = forgetPwdStatus;
	}

	public Boolean getActiveStatus() {
		return activeStatus;
	}

	public void setActiveStatus(Boolean activeStatus) {
		this.activeStatus = activeStatus;
	}

    public Long getRoleCategory() {
        return roleCategory;
    }

    public void setRoleCategory(Long roleCategory) {
        this.roleCategory = roleCategory;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

	public String getModifyPricelevelTime() {
		return modifyPricelevelTime;
	}

	public void setModifyPricelevelTime(String modifyPricelevelTime) {
		this.modifyPricelevelTime = modifyPricelevelTime;
	}

	public Boolean getNewContract() {
		return newContract;
	}

	public void setNewContract(Boolean newContract) {
		this.newContract = newContract;
	}

	@Transient
    public String getRoleName() {
        return roleName;
    }

    public void setRoleName(String roleName) {
        this.roleName = roleName;
    }

    @Transient
    public Long getParentRole() {
        return parentRole;
    }

    public void setParentRole(Long parentRole) {
        this.parentRole = parentRole;
    }

    @Transient
    public String getAuthStr() {
        return authStr;
    }

    public void setAuthStr(String authStr) {
        this.authStr = authStr;
    }

    @Transient
    public List<UserLog> getUserLogList() {
        return userLogList;
    }

    public void setUserLogList(List<UserLog> userLogList) {
        this.userLogList = userLogList;
    }

    @Transient
    public boolean getIsMasterLogin() {
        return isMasterLogin;
    }

    public void setIsMasterLogin(boolean isMasterLogin) {
        this.isMasterLogin = isMasterLogin;
    }

    @Transient
    public List<Auth> getAuthList() {
        return authList;
    }

    public void setAuthList(List<Auth> authList) {
        this.authList = authList;
    }

    @Transient
    public String getCreateAccountName() {
        return createAccountName;
    }

    public void setCreateAccountName(String createAccountName) {
        this.createAccountName = createAccountName;
    }

    @Transient
    public String getModifyAccountName() {
        return modifyAccountName;
    }

    public void setModifyAccountName(String modifyAccountName) {
        this.modifyAccountName = modifyAccountName;
    }

    @Transient
    public Boolean getValid() {
        return valid;
    }

    public void setValid(Boolean valid) {
        this.valid = valid;
    }

    @Transient
    public int getAppSize()
    {
        return appSize;
    }

    public void setAppSize(int appSize)
    {
        this.appSize = appSize;
    }

	public Boolean getAllChannelValidMatch() {
		return allChannelValidMatch;
	}

	public void setAllChannelValidMatch(Boolean allChannelValidMatch) {
		this.allChannelValidMatch = allChannelValidMatch;
	}

	public Boolean getAllChannelFakeMatch() {
		return allChannelFakeMatch;
	}

	public void setAllChannelFakeMatch(Boolean allChannelFakeMatch) {
		this.allChannelFakeMatch = allChannelFakeMatch;
	}

	public Boolean getAllChannelBlackMatch() {
		return allChannelBlackMatch;
	}

	public void setAllChannelBlackMatch(Boolean allChannelBlackMatch) {
		this.allChannelBlackMatch = allChannelBlackMatch;
	}

    public String getRegIpAddr()
    {
        return regIpAddr;
    }

    public void setRegIpAddr(String regIpAddr)
    {
        this.regIpAddr = regIpAddr;
    }

    public String getRegIpLocation()
    {
        return regIpLocation;
    }

    public void setRegIpLocation(String regIpLocation)
    {
        this.regIpLocation = regIpLocation;
    }

    public Boolean getVerifyEmail()
    {
        return verifyEmail;
    }

    public void setVerifyEmail(Boolean verifyEmail)
    {
        this.verifyEmail = verifyEmail;
    }

	@Override
	public String toString() {
		return "Account{" +
				"id=" + id +
				", email='" + email + '\'' +
				", password='" + password + '\'' +
				", company='" + company + '\'' +
				", name='" + name + '\'' +
				", phone='" + phone + '\'' +
				", qq='" + qq + '\'' +
				", wechat='" + wechat + '\'' +
				", isSuperUser=" + isSuperUser +
				", parent=" + parent +
				", isSpecialAccount='" + isSpecialAccount + '\'' +
				", status=" + status +
				", pastDate='" + pastDate + '\'' +
				", createTime=" + createTime +
				", pubDate=" + pubDate +
				", createAccount=" + createAccount +
				", modifyTime=" + modifyTime +
				", modifyAccount=" + modifyAccount +
				", delFlag=" + delFlag +
				", roleCategory=" + roleCategory +
				", authStr='" + authStr + '\'' +
				", isChannelPerson=" + isChannelPerson +
				", channelAccount='" + channelAccount + '\'' +
				", userLogList=" + userLogList +
				", isMasterLogin=" + isMasterLogin +
				", pricelevel=" + pricelevel +
				", bussinessman=" + bussinessman +
				", activeTime=" + activeTime +
				", forgetPwdTime=" + forgetPwdTime +
				", forgetPwdStatus=" + forgetPwdStatus +
				", activeStatus=" + activeStatus +
				'}';
	}
}
