package com.reyun.model;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;

/**
 * Created by sunhao on 17/4/20.
 * desc:看单收藏夹
 */
@Entity
public class CustomMenuFavorites {

    private Long id;

    private Long accountId;

    private Long appId;

    private Long shareId;

    private Date createDate;

    private Double matchPercent;

    private Boolean delFlag;
    //true分享有效,false分享无效
    private Boolean shareValid;

    public CustomMenuFavorites(){}

    public CustomMenuFavorites(Long accountId, Long appId, Long shareId, Double matchPercent){

        this.accountId = accountId;
        this.appId = appId;
        this.shareId = shareId;
        this.createDate = new Date();
        this.matchPercent = matchPercent;
        this.delFlag = false;
        this.shareValid = true;
    }

    @Id
    @GeneratedValue
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getAppId() {
        return appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getShareId() {
        return shareId;
    }

    public void setShareId(Long shareId) {
        this.shareId = shareId;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Double getMatchPercent() {
        return matchPercent;
    }

    public void setMatchPercent(Double matchPercent) {
        this.matchPercent = matchPercent;
    }

    public Boolean getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(Boolean delFlag) {
        this.delFlag = delFlag;
    }

    public Boolean getShareValid() {
        return shareValid;
    }

    public void setShareValid(Boolean shareValid) {
        this.shareValid = shareValid;
    }
}
