package com.reyun.model;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.util.Date;
import java.util.List;

/**
 * Created by sunhao on 17/4/20.
 * desc:分享看单
 */
@Entity
public class CustomMenuShare {

    private Long id;

    private Long accountId;

    private String accountName;

    private String name;

    private Long category;

    private String categoryName;

    private Boolean delFlag;

    private Date shareDate;

    private Long originalMenu;
    //使用人数
    private Long useNumber;
    //收藏次数
    private Long favoriteNumber;
    //是否是热云分享的看单
    private Boolean reyunMenu;

    //Transient,分享ID
    private Long shareId;
    //Transient,展示是否有效
    private Boolean shareValid;
    //Transient,展示匹配度
    private Double matchPercent;
    //Transient,展示是否收藏
    private Boolean hasFavorite;
    //Transient,展示是否使用
    private Boolean hasUsed;
    //Transient,展示看单的模板
    private List<CustomMenuShareTemplate> templates;


    public CustomMenuShare(){}

    public CustomMenuShare(CustomMenuShare customMenuShare){
        this.accountId = customMenuShare.getAccountId();
        this.accountName = customMenuShare.getAccountName();
        this.name = customMenuShare.getName();
        this.category = customMenuShare.getCategory();
    }

    @Id
    @GeneratedValue
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getAccountName() {
        return accountName;
    }

    public void setAccountName(String accountName) {
        this.accountName = accountName;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getCategory() {
        return category;
    }

    public void setCategory(Long category) {
        this.category = category;
    }

    public String getCategoryName() {
        return categoryName;
    }

    public void setCategoryName(String categoryName) {
        this.categoryName = categoryName;
    }

    public Boolean getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(Boolean delFlag) {
        this.delFlag = delFlag;
    }

    public Date getShareDate() {
        return shareDate;
    }

    public void setShareDate(Date shareDate) {
        this.shareDate = shareDate;
    }

    public Long getOriginalMenu() {
        return originalMenu;
    }

    public void setOriginalMenu(Long originalMenu) {
        this.originalMenu = originalMenu;
    }

    public Long getUseNumber() {
        return useNumber;
    }

    public void setUseNumber(Long useNumber) {
        this.useNumber = useNumber;
    }

    public Long getFavoriteNumber() {
        return favoriteNumber;
    }

    public void setFavoriteNumber(Long favoriteNumber) {
        this.favoriteNumber = favoriteNumber;
    }

    public Boolean getReyunMenu() {
        return reyunMenu;
    }

    public void setReyunMenu(Boolean reyunMenu) {
        this.reyunMenu = reyunMenu;
    }

    @Transient
    public Long getShareId() {
        return shareId;
    }

    public void setShareId(Long shareId) {
        this.shareId = shareId;
    }

    @Transient
    public Boolean getShareValid() {
        return shareValid;
    }

    public void setShareValid(Boolean shareValid) {
        this.shareValid = shareValid;
    }

    @Transient
    public Double getMatchPercent() {
        return matchPercent;
    }

    public void setMatchPercent(Double matchPercent) {
        this.matchPercent = matchPercent;
    }

    @Transient
    public Boolean getHasFavorite() {
        return hasFavorite;
    }

    public void setHasFavorite(Boolean hasFavorite) {
        this.hasFavorite = hasFavorite;
    }

    @Transient
    public Boolean getHasUsed() {
        return hasUsed;
    }

    public void setHasUsed(Boolean hasUsed) {
        this.hasUsed = hasUsed;
    }

    @Transient
    public List<CustomMenuShareTemplate> getTemplates() {
        return templates;
    }

    public void setTemplates(List<CustomMenuShareTemplate> templates) {
        this.templates = templates;
    }
}
