package com.reyun.model;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.util.Date;

/**
 * Created by sunhao on 17/4/27.
 * desc:分享看单模板
 */
@Entity
public class CustomMenuShareTemplate {


    private Long id;

    private Long accountId;

    private Long customMenuId;
    //模板名称
    private String name;
    //查询条件
    private String queryCondition;
    //所有事件
    private String events;
    //留存参数
    private int relativeTime;
    //查询SQL
    private String querySql;
    //报表类型,事件分析,漏斗,留存
    private  String menuType;
    //分享后查询出的数据,自建模板无数据
    private String queryData;
    //漏斗,留存,事件分析的ID
    private Long originalReportId;

    private Date createDate;

    private Long modifyAccount;

    private Date modifyDate;

    private Boolean delFlag;

    //Transient 是否匹配
    private Boolean hasMatch;

    private String type;

    private String descb;

    public CustomMenuShareTemplate(){}

    public CustomMenuShareTemplate(CustomMenuShareTemplate customMenuShareTemplate){
        this.accountId = customMenuShareTemplate.getAccountId();
        this.name = customMenuShareTemplate.getName();
        this.queryCondition = customMenuShareTemplate.getQueryCondition();
        this.querySql = customMenuShareTemplate.getQuerySql();
        this.events = customMenuShareTemplate.getEvents();
        this.relativeTime = customMenuShareTemplate.getRelativeTime();
        this.menuType = customMenuShareTemplate.getMenuType();
        this.modifyAccount = customMenuShareTemplate.getModifyAccount();
        this.originalReportId = customMenuShareTemplate.getOriginalReportId();
        this.createDate = new Date();
        this.modifyDate = new Date();
        this.delFlag = false;
    }

    public CustomMenuShareTemplate(CustomMenuTemplate customMenuTemplate){
        this.accountId = customMenuTemplate.getAccountId();
        this.name = customMenuTemplate.getName();
        this.menuType = customMenuTemplate.getMenuType();
        this.modifyAccount = customMenuTemplate.getModifyAccount();
        this.originalReportId = customMenuTemplate.getOriginalReportId();
        this.createDate = new Date();
        this.modifyDate = new Date();
        this.delFlag = false;
    }

    @Id
    @GeneratedValue
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getAccountId() {
        return accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public Long getCustomMenuId() {
        return customMenuId;
    }

    public void setCustomMenuId(Long customMenuId) {
        this.customMenuId = customMenuId;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getQueryCondition() {
        return queryCondition;
    }

    public void setQueryCondition(String queryCondition) {
        this.queryCondition = queryCondition;
    }

    public String getEvents() {
        return events;
    }

    public void setEvents(String events) {
        this.events = events;
    }

    public String getQuerySql() {
        return querySql;
    }

    public void setQuerySql(String querySql) {
        this.querySql = querySql;
    }

    public String getMenuType() {
        return menuType;
    }

    public void setMenuType(String menuType) {
        this.menuType = menuType;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public Long getModifyAccount() {
        return modifyAccount;
    }

    public void setModifyAccount(Long modifyAccount) {
        this.modifyAccount = modifyAccount;
    }

    public Date getModifyDate() {
        return modifyDate;
    }

    public void setModifyDate(Date modifyDate) {
        this.modifyDate = modifyDate;
    }

    public String getQueryData() {
        return queryData;
    }

    public void setQueryData(String queryData) {
        this.queryData = queryData;
    }

    public Boolean getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(Boolean delFlag) {
        this.delFlag = delFlag;
    }

    public Long getOriginalReportId() {
        return originalReportId;
    }

    public void setOriginalReportId(Long originalReportId) {
        this.originalReportId = originalReportId;
    }

    public int getRelativeTime() {
        return relativeTime;
    }

    public void setRelativeTime(int relativeTime) {
        this.relativeTime = relativeTime;
    }

    @Transient
    public Boolean getHasMatch() {
        return hasMatch;
    }

    public void setHasMatch(Boolean hasMatch) {
        this.hasMatch = hasMatch;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getDescb() {
        return descb;
    }

    public void setDescb(String descb) {
        this.descb = descb;
    }
}
