package com.reyun.model;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.Transient;
import java.util.Date;

/**
 * Created by sunhao on 17/7/18.
 * desc:智能路径model
 */
@Entity
public class IntelligentPath {

    private Long id;

    private Long app;

    private Long createAccount;

    private Date createTime;

    private String name;
    //关注事件
    private String events;
    //开始事件或者结束事件标示
    private Boolean startOrEnd;
    //目标事件
    private String targetEvent;
    //session时长
    private Long session;
    //session单位
    private Long sessionUnit;
    //事件条件
    private String eventCondition;
    //用户分群
    private Long userGroup;

    private Long modifyAccount;

    private Date modifyTime;

    private Boolean delFlag;

    //transient
    private String startDate;

    private String endDate;

    public IntelligentPath(){}

    public IntelligentPath(Long app, String events, Boolean startOrEnd, String targetEvent, Long session, Long sessionUnit,
                           String eventCondition, String startDate, String endDate) {
        this.app = app;
        this.events = events;
        this.startOrEnd = startOrEnd;
        this.targetEvent = targetEvent;
        this.session = session;
        this.sessionUnit = sessionUnit;
        this.eventCondition = eventCondition;
        this.startDate = startDate;
        this.endDate = endDate;
    }


    @Id
    @GeneratedValue
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Long getApp() {
        return app;
    }

    public void setApp(Long app) {
        this.app = app;
    }

    public Long getCreateAccount() {
        return createAccount;
    }

    public void setCreateAccount(Long createAccount) {
        this.createAccount = createAccount;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getEvents() {
        return events;
    }

    public void setEvents(String events) {
        this.events = events;
    }

    public Boolean getStartOrEnd() {
        return startOrEnd;
    }

    public void setStartOrEnd(Boolean startOrEnd) {
        this.startOrEnd = startOrEnd;
    }

    public String getTargetEvent() {
        return targetEvent;
    }

    public void setTargetEvent(String targetEvent) {
        this.targetEvent = targetEvent;
    }

    public Long getSession() {
        return session;
    }

    public void setSession(Long session) {
        this.session = session;
    }

    public Long getSessionUnit() {
        return sessionUnit;
    }

    public void setSessionUnit(Long sessionUnit) {
        this.sessionUnit = sessionUnit;
    }

    public String getEventCondition() {
        return eventCondition;
    }

    public void setEventCondition(String eventCondition) {
        this.eventCondition = eventCondition;
    }

    public Long getUserGroup() {
        return userGroup;
    }

    public void setUserGroup(Long userGroup) {
        this.userGroup = userGroup;
    }

    public Long getModifyAccount() {
        return modifyAccount;
    }

    public void setModifyAccount(Long modifyAccount) {
        this.modifyAccount = modifyAccount;
    }

    public Date getModifyTime() {
        return modifyTime;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public Boolean getDelFlag() {
        return delFlag;
    }

    public void setDelFlag(Boolean delFlag) {
        this.delFlag = delFlag;
    }

    @Transient
    public String getStartDate() {
        return startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    @Transient
    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }
}
