package com.reyun.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.io.IOException;
import java.util.List;

/**
 * Created by nolan on 15/12/2016.
 * description:
 */
public class ResultAuthModel {
    private String retention;
    private String pay;
    private String isnatureopen;
    @JsonIgnore
    private List<ResultNode> nodes;

    public String getRetention() {
        return retention;
    }

    public void setRetention(String retention) {
        this.retention = retention;
    }

    public String getPay() {
        return pay;
    }

    public void setPay(String pay) {
        this.pay = pay;
    }

    public String getIsnatureopen() {
        return isnatureopen;
    }

    public void setIsnatureopen(String isnatureopen) {
        this.isnatureopen = isnatureopen;
    }

    public List<ResultNode> getNodes() {
        return nodes;
    }

    public void setNodes(List<ResultNode> nodes) {
        this.nodes = nodes;
    }

    @Override
    public String toString() {
        return "ResultAuthModel{" +
                "retention='" + retention + '\'' +
                ", pay='" + pay + '\'' +
                ", isnatureopen='" + isnatureopen + '\'' +
                ", nodes=" + nodes +
                '}';
    }


    static  class ResultNode {
        private String name;
        private String zh;
        private String canselect;
        private int parent;
        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getZh() {
            return zh;
        }

        public void setZh(String zh) {
            this.zh = zh;
        }

        public String getCanselect() {
            return canselect;
        }

        public void setCanselect(String canselect) {
            this.canselect = canselect;
        }

        public int getParent() {
            return parent;
        }

        public void setParent(int parent) {
            this.parent = parent;
        }

        @Override
        public String toString() {
            return "ResultNode{" +
                    "name='" + name + '\'' +
                    ", zh='" + zh + '\'' +
                    ", canselect='" + canselect + '\'' +
                    ", parent=" + parent +
                    '}';
        }
    }

    public static void main(String[] args) throws IOException {
        String str = "{\n" +
                "  \"retention\": \"true\",\n" +
                "  \"pay\": \"false\",\n" +
                "  \"isnatureopen\": \"true\",\n" +
                "  \"nodes\": [\n" +
                "    {\n" +
                "      \"name\": \"transform\",\n" +
                "      \"zh\": \"转化分析\",\n" +
                "      \"canselect\": \"true\",\n" +
                "      \"parent\": 1\n" +
                "    },\n" +
                "    {\n" +
                "      \"name\": \"decisionsupport\",\n" +
                "      \"zh\": \"决策支持\",\n" +
                "      \"canselect\": \"true\",\n" +
                "      \"parent\": 1\n" +
                "    },\n" +
                "    {\n" +
                "      \"name\": \"campaignmanage\",\n" +
                "      \"zh\": \"活动管理\",\n" +
                "      \"canselect\": \"false\",\n" +
                "      \"parent\": 2\n" +
                "    },\n" +
                "    {\n" +
                "      \"name\": \"authmanage\",\n" +
                "      \"zh\": \"成员管理\",\n" +
                "      \"canselect\": \"false\",\n" +
                "      \"parent\": 3\n" +
                "    }\n" +
                "  ]\n" +
                "}";
        ResultAuthModel resultAuthModel = new ObjectMapper().readValue(str, ResultAuthModel.class);
    }
}

