package com.reyun.repository;

import com.reyun.model.Account;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigInteger;
import java.util.Date;
import java.util.List;

@Transactional
public interface AccountRepository extends JpaRepository<Account, Long> {

    @Query(value = "select * from account where id in  (select distinct account  from auth where app = ?1 and status is true) " +
            " and id in (select distinct account from data_auth where app=?1 and all_campaign is false)" +
            " and del_flag is not true and status = 1 and (past_date is null or past_date >= ?2) ", nativeQuery = true)
    List<Account> findAuthorizedSubAndChannelAccount(Long appId, String currentDate);

    @Query(value = "select * from account where email = ?1", nativeQuery = true)
    Account findAccountByEmail(String email);

    @Query(value = "select * from account where parent = ?1 and status = 1 order by create_time desc", nativeQuery = true)
    List<Account> findAccountByParent(Long parent);

    @Query(value = "select * from account where parent = ?1 and id <> ?1 and is_channel_person is not true and status in (1,-3) order by modify_time desc", nativeQuery = true)
    List<Account> findActiveByParent(Long accountId);

    @Query(value = "select * from account where root_parent = ?1 and id <> ?1 and is_channel_person is not true and status in (1,-3) order by modify_time desc", nativeQuery = true)
    List<Account> findActiveByRoot(Long accountId);

    @Query(value = "select * from account where root_parent = ?1 and id <> ?1 and id <> ?2 and is_channel_person is not true and status in (1,-3) order by modify_time desc", nativeQuery = true)
    List<Account> findActiveByRootExcludeSelf(Long rootParentId, Long accountId);

    @Query(value = "select * from account where parent = ?1 and id <> ?1 and is_channel_person is not true  and status = 0 order by modify_time desc", nativeQuery = true)
    List<Account> findDisableByParent(Long accountId);

    @Query(value = "select * from account where root_parent = ?1 and id <> ?1 and is_channel_person is not true  and status = 0 order by modify_time desc", nativeQuery = true)
    List<Account> findDisableByRoot(Long accountId);

    @Query(value = "select * from account where root_parent = ?1 and id <> ?1 and id <> ?2 and is_channel_person is not true  and status = 0 order by modify_time desc", nativeQuery = true)
    List<Account> findDisableByRootExcludeSelf(Long rootParentId, Long accountId);

    @Query(value = "select * from account where id = ?1 and password = ?2 ", nativeQuery = true)
    Account findAccountByIdAndPwd(Long accountId, String pwd);

    @Query(value = "select id from account where id = ?1 or parent = ?1", nativeQuery = true)
    List<Long> findAllAccountList(Long parentAccountId);

    @Query(value = "select * from account where id in ?1 and role_category = 5 order by modify_time desc", nativeQuery = true)
    List<Account> findChannelAccountByAccountIds(List<Long> channelAccountIds);

    @Query(value = "select * from account where id in (select distinct create_account from account where id in ?1 and create_account is not null " +
            " union " +
            "select distinct modify_account from account where id in ?1 and modify_account is not null) ", nativeQuery = true)
    List<Account> findCreateAndModifyAccount(List<Long> accountIds);

    @Query(value = "select count(*) from account where role_category = ?1 ", nativeQuery = true)
    BigInteger findAccountNumByRoleId(Long roleId);

    @Query(value = "select count(*) from account where parent = ?1 and role_category = 1 ", nativeQuery = true)
    BigInteger findSubMangerNumByParent(Long parentId);

    @Query(value = "select * from account where root_parent = ?1 and id <> ?1 and status = 1 order by create_time desc", nativeQuery = true)
    List<Account> findAccountByRootParent(Long rootParent);


    @Query(value = "select * from account where root_parent = ?1 and id <> ?2 and id <> ?1 and status = 1 order by create_time desc", nativeQuery = true)
    List<Account> findAccountByRootParentExManager(Long rootParent, Long id);

    @Query(value = "select root_parent from account where id=?1", nativeQuery = true)
    BigInteger findRootParentByAccountId(Long accountId);

    @Query(value = "select * from account where status=1 and flow_restrict is TRUE and is_super_user is TRUE;", nativeQuery = true)
    List<Account> findSuperAccount();

    @Transactional
    @Modifying
    @Query(value = "update Account set status = 1 where id = ?1")
    int enable(Long account);

    @Transactional
    @Modifying
    @Query(value = "update Account set status = 0 where id = ?1")
    int forbidden(Long account);

    @Transactional
    @Modifying
    @Query(value = "update Account set status = 0, modify_account = ?1,modify_time = ?2 where id = ?3")
    int disableSubAccount(Long modifyAccount, Date modifyTime, Long subAccount);

    @Transactional
    @Modifying
    @Query(value = "update Account set status = 1, modify_account = ?1,modify_time = ?2,is_special_account=0 where id = ?3")
    int enableSubAccount(Long modifyAccount, Date modifyTime, Long subAccount);

    List<Account> findByParent(Long account);

    @Transactional
    @Modifying
    @Query(value = "update Account a set a.name = ?1 ,a.company = ?2 , a.phone = ?3 , a.wechat = ?4 , a.qq = ?5 where a.id = ?6")
    int updateAccountBaseInfo(String name, String company, String phone, String wechat, String qq, Long accountId);

    @Transactional
    @Modifying
    @Query(value = "update Account a set a.password = ?1 where a.password = ?2 and a.id = ?3")
    int updateAccountPwd(String newPassword, String oldPassword, Long accountId);
}
