package com.reyun.repository;

import com.reyun.model.App;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

public interface AppRepository extends JpaRepository<App, Long>
{

	@Query(value = "select * from app where account in (select id from account where parent = ?1 or id = ?1) and del_flag is not true", nativeQuery = true)
	List<App> listAppByRootAccount(Long account);
	
	@Query(value="select appkey from app where id = ?1",nativeQuery=true)
	String findAppkeyById(Long id);
	
	@Query(value = "select * from app where account =?1 and bundleid = ?2 and del_flag is not true", nativeQuery = true)
    App findByBundleidInNotDel(Long account, String bundleid);
	
	@Query(value = "select * from app where account =?1 and name = ?2 and del_flag is not true", nativeQuery = true)
    App findByNameNotDel(Long account, String name);

	@Query(value = "select * from app where id in ?1", nativeQuery = true)
	List<App> findByIds(List<Long> ids);

    @Query(value = "select * from app a join auth b on a.id = b.app where b.account = ?1 and b.create_account in (select id from account where root_parent = ?2) ", nativeQuery = true)
    List<App> findAuthAppByRootParent(Long subAccountId, Long rootParent);

    @Query(value = "select * from app a join auth b on a.id = b.app where b.account = ?1 ", nativeQuery = true)
    List<App> findAuthApp(Long subAccountId);

	@Query(value="select platform from app where id = ?1",nativeQuery=true)
	String findPlatformByAppId(Long appId);


	@Query(value="select categoryname from category where categoryid=(select app_genre from app where id=?1);",nativeQuery=true)
	String findAppGenreNameByAppID(Long id);

	@Query(value = "select * from app where appkey = ?1", nativeQuery = true)
	App findByAppkey(String appkeys);

}
