package com.reyun.repository;

import com.reyun.model.AppTag;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;

import java.util.List;

/**
 * description:
 *
 * @author nolan
 * @date 26/12/2017
 */
public interface AppTagRepository extends JpaRepository<AppTag, Long>
{

    @Query(value = "select * from app_tag where app=?1", nativeQuery = true)
    List<AppTag> findByApp(Long app);

    @Query(value = "delete from app_tag where app=?1 ", nativeQuery = true)
    @Modifying
    int deleteByApp(Long app);
}
