package com.reyun.repository;

import com.reyun.model.CommonEvent;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * Created by sunhao on 17/4/13.
 * description:通用事件DAO
 */
public interface CommonEventRepository extends JpaRepository<CommonEvent,Long>{

    @Query(value="select * from common_event ",nativeQuery=true)
    List<CommonEvent> findAll();
    
    @Query(value="select * from common_event where event=?1",nativeQuery=true)
    CommonEvent findByEvent(String event);

    @Query(value = "SELECT * FROM `common_event` WHERE `alias`=?1", nativeQuery = true)
    CommonEvent findByAlias(String alias);
}
