package com.reyun.repository;

import com.reyun.model.CommonIP;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigInteger;
import java.util.Date;
import java.util.List;

@Transactional
public interface CommonIPRepository extends JpaRepository<CommonIP, Long> {

	@Query(value = "select * from commonip where del_flag is not true and account = ?1", nativeQuery = true)
    List<CommonIP> findAllCommonIPByAccount(Long account);
	
	@Modifying
    @Transactional
    @Query(value = "update commonip set del_flag = true, modify_account = ?1 , modify_time = ?2 where id = ?3 and del_flag is not true", nativeQuery = true)
    int deleteById(Long modifyAccount,  Date modifyTime, Long id);
	
	@Transactional
    @Modifying
    @Query(value = "update commonip set ip  = ?1 , modify_account = ?2 , modify_time = ?3 where id = ?4 ", nativeQuery = true)
    int updateCommonIPById(String ip,Long modifyAccount,  Date modifyTime, Long id);
	
	@Query(value = "select count(1) from commonip where del_flag is not true and account =?1 and ip=?2 ", nativeQuery = true)
	BigInteger isCommonIpRepeatByAccount(Long account,String ip);
}
