package com.reyun.repository;

import com.reyun.model.CustomMenuFavorites;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by sunhao on 17/4/24.
 * desc:收藏看单DAO
 */
public interface CustomMenuFavoritesRepository extends JpaRepository<CustomMenuFavorites, Long> {


    @Query(value = "select * from custom_menu_favorites where account_id = ?1 and app_id = ?2 and del_flag is false order by create_date desc ", nativeQuery = true)
    List<CustomMenuFavorites> findAllFavorites(Long accountId,Long appId);

    @Query(value = "select * from custom_menu_favorites where account_id = ?1 and app_id = ?2 and share_id =?3 and del_flag is false limit 1", nativeQuery = true)
    CustomMenuFavorites findFavoriteMenuByShareId(Long accountId,Long appId,Long shareId);

    @Query(value = "select * from custom_menu_favorites where account_id = ?1 and app_id = ?2 and share_id =?3 and del_flag is true limit 1", nativeQuery = true)
    CustomMenuFavorites findHasAddToFavorite(Long accountId,Long appId,Long shareId);

    @Transactional
    @Modifying
    @Query(value = "update custom_menu_favorites set del_flag = true where account_id = ?1 and app_id = ?2 and share_id =?3 and del_flag is false ", nativeQuery = true)
    int deleteFavorites(Long accountId,Long appId,Long menuId);


    @Transactional
    @Modifying
    @Query(value = "update custom_menu_favorites set del_flag = false where account_id = ?1 and app_id = ?2 and share_id =?3 and del_flag is true ", nativeQuery = true)
    int restoreFavorites(Long accountId,Long appId,Long menuId);

    @Transactional
    @Modifying
    @Query(value = "update custom_menu_favorites set share_valid = false where share_id = ?1 and del_flag is false ", nativeQuery = true)
    int updateFavoritesShareInvalid(Long menuId);
}
