package com.reyun.repository;

import com.reyun.model.CustomMenu;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigInteger;
import java.util.Date;
import java.util.List;

/**
 * Created by sunhao on 17/4/21.
 * desc:我的看单
 */
public interface CustomMenuRepository extends JpaRepository<CustomMenu, Long> {

    @Query(value = "select * from custom_menu where create_account  = ?1 and app_id  = ?2 and share_id = ?3 and source is true and del_flag is false ", nativeQuery = true)
    CustomMenu findCustomMenuByShareId(Long accountId, Long appId, Long shareId);

    //查询所有有效地看单
    @Query(value = "select * from custom_menu where create_account = ?1 and app_id = ?2 and del_flag is false order by ifnull(modify_date,create_date) desc ", nativeQuery = true)
    List<CustomMenu> findValidCustomMenu(Long accountId, Long appId);

    //按照app查询所有有效地看单
    @Query(value = "select * from custom_menu where app_id = ?1 and del_flag is false order by orderindex ", nativeQuery = true)
    List<CustomMenu> findValidCustomMenuByApp(Long appId);

    //查询所有失效的看单
    @Query(value = "select * from custom_menu where  app_id = ?1 ", nativeQuery = true)
    List<CustomMenu> findAllCustomMenuByApp(Long appId);

    @Query(value = "select * from custom_menu where  id in ?1 and del_flag is false ", nativeQuery = true)
    List<CustomMenu> findAllByIds(List<Long> list);

    @Query(value = "select * from custom_menu where id = ?1 and has_share is false ", nativeQuery = true)
    CustomMenu findUnsharedMenu(Long menuId);

    @Query(value = "select count(*) from custom_menu where app_id = ?1 and del_flag is false ", nativeQuery = true)
    BigInteger findMyMenuNumber(Long appId);

    @Query(value = "select count(*) from custom_menu where app_id = ?1 and  name = ?2  and del_flag is false ", nativeQuery = true)
    BigInteger findMyMenuNumberByName(Long appId,String menuName);

    @Query(value = "select count(*) from custom_menu where app_id = ?1 and  name like ?2%  and del_flag is false ", nativeQuery = true)
    BigInteger findNameLikeNumber(Long appId,String menuName);

    @Query(value = "select count(*) from custom_menu where app_id = ?1 and share_id = ?2 and del_flag is false ", nativeQuery = true)
    BigInteger findByShareId(Long appId, Long shareId);

    @Transactional
    @Modifying
    @Query(value = "update custom_menu set del_flag = true where create_account = ?1 and app_id = ?2 and id = ?3 and del_flag is false ", nativeQuery = true)
    int deleteMyMenu(Long accountId, Long appId, Long menuId);

    @Transactional
    @Modifying
    @Query(value = "update custom_menu set has_share = ?2 where id = ?1 and del_flag is false ", nativeQuery = true)
    int updateMyMenuShare(Long menuId, Boolean isShare);

    @Transactional
    @Modifying
    @Query(value = "update custom_menu set name = ?3,modify_date = ?4,modify_account = ?1 where id = ?2 and del_flag is false ", nativeQuery = true)
    int updateMyMenuName(Long accountId, Long menuId, String name, Date date);

    @Transactional
    @Modifying
    @Query(value = "update custom_menu set create_account_name = ?2 where create_account = ?1 ", nativeQuery = true)
    int updateAccountName(Long accountId, String accountName);

    @Transactional
    @Modifying
    @Query(value = "update custom_menu set share_account_name = ?2 where share_account_id = ?1 ", nativeQuery = true)
    int updateShareAccountName(Long accountId, String accountName);

}
