package com.reyun.repository;

import com.reyun.model.CustomMenuTemplate;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.math.BigInteger;
import java.util.List;

/**
 * Created by sunhao on 17/4/24.
 * desc:我的看单包含的模板DAO
 */
public interface CustomMenuTemplateRepository extends JpaRepository<CustomMenuTemplate,Long>{

    @Query(value = "select * from custom_menu_template where custom_menu_id = ?1 and del_flag is false order by orderindex ", nativeQuery = true)
    List<CustomMenuTemplate> findMyTemplateById(Long customMenuId);

    @Query(value = "select * from custom_menu_template where custom_menu_id = ?1 and original_report_id = ?2 and menu_type = ?3  and del_flag is false ", nativeQuery = true)
    CustomMenuTemplate findMyTemplateByReportId(Long customMenuId, Long reportId, String menuType);

    @Query(value = "select count(*) from custom_menu_template where custom_menu_id = ?1 and del_flag is false ", nativeQuery = true)
    BigInteger countNumberByMenu(Long menuId);

    @Query(value = "select id from custom_menu_template where original_report_id = ?1 and menu_type = ?2 and del_flag is false", nativeQuery = true)
    List<Long> findTemplateByOriginal(Long originalId, String menuType);

    @Query(value = "select * from custom_menu_template where original_report_id = ?1 and menu_type = ?2 and del_flag is false", nativeQuery = true)
    List<CustomMenuTemplate> findAllTemplateByOriginal(Long originalId, String menuType);

    @Query(value = "select custom_menu_id from custom_menu_template where original_report_id = ?1 and menu_type = ?2 and del_flag is false", nativeQuery = true)
    List<Long> findMenuByOriginal(Long originalId, String menuType);

    @Transactional
    @Modifying
    @Query(value = "update custom_menu_template set del_flag = true, modify_account = ?1 where id in ?2 and del_flag is false ", nativeQuery = true)
    int deleteTemplateByIds(Long accountId, List<Long> templateIds);

    @Transactional
    @Modifying
    @Query(value = "update custom_menu_template set del_flag = true, modify_account = ?1 where id = ?2 and del_flag is false ", nativeQuery = true)
    int updateTemplateInvalid(Long accountId, Long templateId);
}
