package com.reyun.repository;

import com.reyun.model.IsNotified;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public interface IsNotifiedRepository extends JpaRepository<IsNotified, Long> {
    @Query(value = "select * from is_notified where account_id=?1", nativeQuery = true)
    IsNotified findIsNotifiedByAccountId(Long accountId);

    @Modifying
    @Transactional
    @Query(value = "delete from is_notified where account_id=?1", nativeQuery = true)
    int deleteByAccountId(Long accountId);


}
