package com.reyun.repository;

import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;

import com.reyun.model.Profile;
import org.springframework.transaction.annotation.Transactional;

public interface ProfileRepository extends JpaRepository<Profile, Long> {
	
	@Query(value = "select * from profile_source where appkey = ?1 and status = 1",nativeQuery = true)
	List<Profile> findByAppkey(String appkey);
	
	@Query(value = "select * from profile_source where appkey = ?1",nativeQuery = true)
	List<Profile> findAllByAppkey(String appkey);

	@Query(value = "select * from profile_source where appkey = ?1 and attr = ?2",nativeQuery = true)
	Profile findAllByAppkeyAndAttr(String appkey, String attr);

	@Transactional
	@Modifying
	@Query(value = "update profile_source set add_stats_condition = ?1  where appkey = ?2  and  attr = ?3",nativeQuery = true)
	int updateByAppkeyAndAttr(boolean flag,String appkey, String attr);
}
