package com.reyun.repository;

import java.math.BigInteger;
import java.util.List;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import com.reyun.model.Retention;
public interface RetentionRepository extends JpaRepository<Retention, Long> {

	@Query(value="select f.*,a.email as cAccount from retention f, account a where f.app=?1 and a.id = ?2 and f.del_flag is not true and a.id=f.create_account order by modify_time desc",nativeQuery = true)
	List<Retention> findAllByApp(Long app , Long account);
	
	@Query(value="select  r.* from retention r where r.app=?1 and r.del_flag is not true order by r.modify_time desc",nativeQuery = true)
	List<Retention> findAllByApp(Long app);

	@Query(value="select * from retention where app=?2 and del_flag is not true and name=?1",nativeQuery=true)
	Retention findByNameAndApp(String name, Long app);

    @Query(value = "select count(*) from retention where create_account = 1? and app=?2 and name like ?3% ", nativeQuery = true)
    BigInteger findCountLikeName(Long accountId, Long appId, String name);
}
