package com.reyun.repository;

import com.reyun.model.RoleAuthDetail;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * Created by sunhao on 17/6/7.
 * Desc:权限详情DAO
 */
public interface RoleAuthDetailRepository extends JpaRepository<RoleAuthDetail,Long>{

    @Query(value = "select * from role_auth_detail where role_id = ?1", nativeQuery = true)
    List<RoleAuthDetail> findDetailByRole(Long roleId);

    @Query(value = "select * from role_auth_detail where role_id = ?1 and (view is true or edit is true)", nativeQuery = true)
    List<RoleAuthDetail> findValidDetailByRole(Long roleId);
}
