package com.reyun.repository;

import com.reyun.model.UserNoticeLog;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * Created by sunhao on 17/3/1.
 */
@Transactional
public interface UserNoticeLogRepository extends JpaRepository<UserNoticeLog, Long> {

    @Query(value = "select * from user_notice_log u where u.accountid = ?1 and u.noticeid in ?2 ",nativeQuery = true)
    List<UserNoticeLog> listUserNoticeLog(Long accountId , List<Long> noticeIdList);

    @Query(value = "select * from user_notice_log u where u.accountid = ?1 and u.noticeid = ?2", nativeQuery = true)
    UserNoticeLog findUserNoticeLog(Long accountId , Long noticeId);
}
