package com.reyun.repository;

import com.reyun.model.ConfigParam;
import com.reyun.model.VirtualEvent;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

/**
 * Created by song on 2017/9/4.
 */
public interface VirtualEventRepository extends JpaRepository<VirtualEvent, Long> {
    @Query(value = "select * from virtual_event where app_id=?1 and type=?2", nativeQuery = true)
    List<VirtualEvent> findEventListByAppIdAndType(Long appId, String type);

    @Query(value = "select * from virtual_event where app_id=?1", nativeQuery = true)
    List<VirtualEvent> findEventListByAppId(Long appId);

    @Query(value = "select * from virtual_event where id=?1", nativeQuery = true)
    List<VirtualEvent> findEventListById(Long id);

    @Query(value = "select * from virtual_event where id!=?1", nativeQuery = true)
    List<VirtualEvent> findEventListByIdNot(Long id);

    @Query(value = "select * from virtual_event where  name = ?1 limit 1", nativeQuery = true)
    VirtualEvent findVirtualEventByEventId(String eventId);

    @Query(value = "select b.* from virtual_event b left join app a on  a.id = b.app_id where a.appkey = ?1 and  b.ch_name = ?2 limit 1", nativeQuery = true)
    VirtualEvent findVirtualEventByChName(String appKey, String eventId);
}
