package com.reyun.security;

/**
 * Created by nolan on 11/11/2016.
 * description:
 */
public interface TokenManager {

    void delMultiRelationshipByKey(String key);
    /**
     * 通过key删除关联关系
     *
     * @param key
     */
    void delRelationshipByKey(String key);

    /**
     * 通过token删除关联关系
     *
     * @param token
     */
    void delRelationshipByToken(String token);

    /**
     * 通过token获得对应的key
     *
     * @param token
     * @return
     */
    String getKeyFromToken(String token);

    /**
     * 通过key获得对应token
     * @param key
     * @return
     */
    String getTokenFromKey(String key);

    /**
     * 根据key生成对应token
     * @param key
     * @return
     */
    String createToken(String key);
}
