package com.reyun.service;

import com.reyun.model.Account;
import com.reyun.model.Auth;
import com.reyun.model.RoleAuth;

import java.util.List;

public interface AuthService {

    RoleAuth getMenuAthByRole(Account loginAccount, Long roleId);

    List<RoleAuth> getAllCustomRoleList(Account loginAccount);

    Account getSubAccountInfo(Long subAccountId);

    Account getSubAccountAuthById(Long subAccountId);

    Account getSubAccountById(Account loginAccount, Long subAccountId);

    List<Account> getAuthorizedSubAndChannelAccount(Account loginAccount, Long appId);

    List<Account> getAllActiveSubAccount(Account loginAccount);

    List<Account> getAllDisableSubAccount(Account loginAccount);

    int enableSubAccountById(Account loginAccount, Long subAccountId);

    int disableSubAccountById(Account loginAccount, Long subAccountId);

    RoleAuth getRoleAuthById(Long roleId);

    Account createSubAccount(Account loginAccount, Account subAccount,  RoleAuth roleAuth);

    Account modifySubAccount(Account loginAccount, Account subAccount, RoleAuth roleAuth);

    RoleAuth createCustomRole(Account loginAccount, RoleAuth roleAuth);

    RoleAuth modifyCustomRole(Account loginAccount, RoleAuth roleAuth);

    int deleteCustomRole(Account loginAccount, Long roleId);

    boolean deleteInactivateSubAccount(Long subAccountId);

    boolean checkCustomRoleName(Account loginAccount, String roleName, Long roleId);

    boolean checkCustomRoleNumber(Account loginAccount);

    boolean checkSubMangerNumber(Account loginAccount);

    boolean checkUpdateSubMangerNumber(Account loginAccount, Account updateAccount);

    boolean checkEmailExists(String email);

    boolean checkCustomRoleAccount(Long roleId);

    boolean isNature(Long account, Long app);

    boolean isOriginAccountPast(Long account);

    Account findRootParentAccount(Long childAccountId);

    Auth findAuth(Long account, Long app);

    Account check(String email);

    List<Long> findAuthAppListByAccount(Long accountId);

    boolean sendSubAccountActivateEmail(Account loginAccount, Account subAccount);

    //TEMP DEAL
    boolean dealWithOldAuth();
}
