package com.reyun.service;

import com.reyun.model.CommonIP;

import java.util.List;

/**
 * Created by mxq on 2017/9/28.
 */
public interface CommonIPService {
    /**
     * 保存
     * @return
     */
    CommonIP save(Long accountId, String ip, Long createAccount);

    /**
     * 公共ip管理--逻辑删除--只是修改delFlag字段
     *
     */
    void delete(Long modifyAccount, Long id);

    /**
     * 修改
     *
     * @param resource
     */
    CommonIP update(String ip,Long modifyAccount, Long id);

    /**
     * 展示母账号下，某渠道的所有公共ip
     * cid 渠道id
     * account 用戶id
     * @return
     */
    List<CommonIP> listCommonIPByAccount(Long account);

    /**
     * id获取CommonIP
     *
     * @param id
     */
    CommonIP findoneById(Long id);

    /**
     * 查询某账号下公共ip是否存在
     * true -存在  false- 不存在
     * @param account
     */
    Boolean checkCommonIp(Long account,String ip);
}
