package com.reyun.service.impl;

import com.reyun.model.CommonIP;
import com.reyun.repository.CommonIPRepository;
import com.reyun.service.CommonIPService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.math.BigInteger;
import java.util.Date;
import java.util.List;

/**
 * Created by mxq on 2017/9/28.
 */
@Service
public class CommonIPServiceImpl implements CommonIPService {

    @Autowired
    CommonIPRepository commonIPRepository;

    @Override
    public CommonIP save(Long accountId, String ip, Long createAccount) {
        CommonIP resource = new CommonIP();

        resource.setAccount(accountId);//母账号
        //resource.setCid(cid);//渠道号
        resource.setIp(ip);
        resource.setCreateAccount(createAccount);//登陆账号
        Date date = new Date();
        resource.setCreateTime(date);
        resource.setModifyAccount(createAccount);
        resource.setModifyTime(date);
        resource.setDelFlag(false);

        return commonIPRepository.save(resource);
    }

    @Override
    public void delete(Long modifyAccount, Long id) {
        commonIPRepository.deleteById(modifyAccount, new Date(), id);
    }

    @Override
    public CommonIP update(String ip, Long modifyAccount, Long id) {
        commonIPRepository.updateCommonIPById(ip, modifyAccount, new Date(), id);
        return commonIPRepository.findOne(id);
    }

    @Override
    public List<CommonIP> listCommonIPByAccount(Long account) {
        return commonIPRepository.findAllCommonIPByAccount(account);
    }

    @Override
    public CommonIP findoneById(Long id) {
        return commonIPRepository.findOne(id);
    }

    @Override
    public Boolean checkCommonIp(Long account, String ip) {
        BigInteger num = commonIPRepository.isCommonIpRepeatByAccount(account, ip);
        return num.intValue()>0 ? true : false;
    }

}
