package com.reyun.service.impl;

import java.util.Date;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.reyun.model.SystemParam;
import com.reyun.repository.SystemParamRepository;
import com.reyun.service.SystemParamService;

@Service
@Transactional
public class SystemParamServiceImpl implements SystemParamService {

	@Autowired
	SystemParamRepository systemParamRepository;
	
	@Override
	public SystemParam update(
			SystemParam resource,Long account) {
		SystemParam set = systemParamRepository.findOne(resource.getId());
		if(resource.getCiDay() != 0){
			set.setCiDay(resource.getCiDay());
		}
		if(resource.getCilag() != 0){
			set.setCilag(resource.getCilag());
		}
		if(resource.getClickDay() != 0){
			set.setClickDay(resource.getClickDay());
		}
		if(resource.getInstallDay() != 0){
			set.setInstallDay(resource.getInstallDay());
		}
		if(resource.getNormalclick()!= 0){
			set.setNormalclick(resource.getNormalclick());
		}
		if(resource.getNormalinstall() != 0){
			set.setNormalinstall(resource.getNormalinstall());
		}
		set.setModifyAccount(account);
		set.setModifyTime(new Date());
		return systemParamRepository.save(set);
	}

	@Override
	public SystemParam find(Long account) {
		return systemParamRepository.findByAccount(account);
	}

	@Override
	public SystemParam create(Long account) {
		
		SystemParam systemParam = new SystemParam();
		systemParam.setAccount(account);
		systemParam.setCiDay(7);
		systemParam.setCilag(5);
		systemParam.setClickDay(30);
		systemParam.setInstallDay(30);
		systemParam.setNormalclick(30);
		systemParam.setNormalinstall(30);
		systemParam.setPubDate(new Date());
		
		return systemParamRepository.save(systemParam);
	}

	


}
