package com.reyun.service.impl;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.reyun.model.Tip;
import com.reyun.repository.TipRepository;
import com.reyun.service.TipService;

@Service
public class TipServiceImpl implements TipService {

	@Autowired
	TipRepository tipRepository;
	@Override
	public Map<String, String> findAllByMenu(String menu) {
		List<Tip> tips = tipRepository.findAllByMenu(menu);
		Map<String, String> result = new HashMap<>();
		for (Tip tip : tips) {
			result.put(tip.getKey(), tip.getTip());
		}
		return result;
	}

	
}
