package com.reyun.service.impl;

import com.reyun.model.Account;
import com.reyun.model.App;
import com.reyun.model.UserLog;
import com.reyun.repository.AccountRepository;
import com.reyun.repository.AppRepository;
import com.reyun.repository.UserLogRepository;
import com.reyun.service.UserLogService;
import com.reyun.taskexecute.UserLogThread;
import com.reyun.util.DateUtil;
import com.reyun.util.IPAddrUtil;
import com.reyun.util.StringUtil;
import com.reyun.util.ValidateUtil;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.math.BigInteger;
import java.util.Date;
import java.util.List;

@Service
public class UserLogServiceImpl implements UserLogService {
	protected Logger logger = LoggerFactory.getLogger(UserLogServiceImpl.class);
	
	@Autowired
	UserLogRepository userLogRepository;
	
	@Autowired
	AccountRepository accountRepository;
	
	@Autowired
	AppRepository appRepository;

	@Override
	public boolean insertLog(Account account, String type, String typeName,
			Object content) {
		UserLogThread userLogThread = new UserLogThread(account.getEmail(), account.getIsMasterLogin(), type, typeName, content, null, null, null);
		userLogThread.start();
		return true;
	}

	@Override
	public boolean insertLog(Account account, String type, String typeName,
			Object content, HttpServletRequest request) {
		UserLogThread userLogThread = new UserLogThread(account.getEmail(), account.getIsMasterLogin(), type, typeName, content, request, null, null);
		userLogThread.start();
		return true;
	}
	
	@Override
	public boolean insertLog(Account account, String type, String typeName,
			Object content, Long app, String objectType) {
		UserLogThread userLogThread = new UserLogThread(account.getEmail(), account.getIsMasterLogin(), type, typeName, content, null, app, objectType);
		userLogThread.start();
		return true;
	}

	@Override
	public boolean insertLog(HttpServletRequest request, String type, String typeName, Long app, String objectType) {
		UserLogThread userLogThread = new UserLogThread("", false, type, typeName, "", request, app, objectType);
		userLogThread.start();
		return true;
	}

	@Override
	public boolean insertLog(Account account, String type, String typeName,
			Object content, Long app, String objectType,HttpServletRequest request) {
		UserLogThread userLogThread = new UserLogThread(account.getEmail(), account.getIsMasterLogin(), type, typeName, content, request, app, objectType);
		userLogThread.start();
		return true;
	}

	@Override
	public boolean insertLog(Account account, String type, String typeName,
			List content, Long app, String objectType,HttpServletRequest request) {
		UserLogThread userLogThread = new UserLogThread(account.getEmail(), account.getIsMasterLogin(), type, typeName, content, request, app, objectType);
		userLogThread.start();
		return true;
	}

	@Override
	public boolean insertLog(Account account, String type, String typeName,
			String content, Long app, String objectType,HttpServletRequest request) {
		UserLogThread userLogThread = new UserLogThread(account.getEmail(), account.getIsMasterLogin(), type, typeName, content, request, app, objectType);
		userLogThread.start();
		return true;
	}

	@Override
	public List<UserLog> findUserLogList(String email, String type,
			String startDate, String endDate, int pageIndex, int pageSize) {
		int start = pageIndex * pageSize;
		if (!StringUtil.isEmpty(email) && !StringUtil.isEmpty(type)) {
			return userLogRepository.findAllByEmailAndType(email, type, startDate, endDate, start, pageSize);
		} else if (!StringUtil.isEmpty(email)) {
			return userLogRepository.findAllByEmail(email, startDate, endDate, start, pageSize);
		} else if (!StringUtil.isEmpty(type)) {
			return userLogRepository.findAllByType(type, startDate, endDate, start, pageSize);
		} else {
			return userLogRepository.findAll(startDate, endDate, start, pageSize);
		}
	}

	@Override
	public BigInteger findUserLogCount(String email, String type,
			String startDate, String endDate) {
		if (!StringUtil.isEmpty(email) && !StringUtil.isEmpty(type)) {
			return userLogRepository.getCount(email, type, startDate, endDate);
		} else if (!StringUtil.isEmpty(email)) {
			return userLogRepository.getCountByEmail(email, startDate, endDate);
		} else if (!StringUtil.isEmpty(type)) {
			return userLogRepository.getCountByType(type, startDate, endDate);
		} else {
			return userLogRepository.getCount(startDate, endDate);
		}
	}



}
