package com.reyun.task;

import com.reyun.model.Account;
import com.reyun.repository.AccountRepository;
import com.reyun.service.AccountFlowRestrictService;
import com.reyun.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.List;

/**
 * Created by song on 2018/2/12.
 */

@Service
public class AutoCalculateFlow {
    private static Logger logger = LoggerFactory.getLogger(AutoCalculateFlow.class);

    @Autowired
    AccountFlowRestrictService accountFlowRestrictService;
    @Autowired
    AccountRepository accountRepository;

    public void run(){
        try{
            List<Account> superAccount = accountRepository.findSuperAccount();
            for(Account account:superAccount){
                String pastDate1 = account.getPastDate();
                String pastDate5 = DateUtil.getBeforeDays(pastDate1, -5);
                Date pastDate = DateUtil.parseDate(pastDate5);
                if(DateUtil.compareDate(pastDate, new Date())!=-1){
                    try{
                        accountFlowRestrictService.RestrictFlowByAccountTask(account.getId());
                    }catch (Exception e){
                        logger.info(e.getMessage());
                    }
                }
            }
        }catch(Exception e){
            e.printStackTrace();
            logger.info(e.getMessage());
        }
    }
}
