package com.reyun.util;

import com.reyun.model.ReportListResult;
import net.sf.json.JSONObject;
import org.springframework.util.CollectionUtils;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/**
 * Created by sunhao on 17/7/7.
 * desc:数据导出工具类
 */
public class ExportReportUtil {

    private static final String REPORT_NAME_CAMPAIGN = "campaigninfo_bycampgroup";
    private static final String SUB_TYPE_CAMPAIGN = "campaign";
    private static final String SPECIAL_REPORT_NAME = "campaigninfo_bydatecampaign";

    private ExportReportUtil(){}

    /**
     * 获取conditionMap避免使用 new ObjectMapper().readValue(export.getConditions(), HashMap.class);转换不完全
     * created by sunhao 20150510
     */
    public static Map<String, String> changeCondition2Map(String conditions) {

        Map<String, String> resultMap = new HashMap<>();

        JSONObject conditionObject = JSONObject.fromObject(conditions);

        Iterator<String> conditionIterator = conditionObject.keys();
        while (conditionIterator.hasNext()) {
            String key = conditionIterator.next();
            resultMap.put(key, conditionObject.getString(key));
        }

        return resultMap;
    }

    public static StringBuffer getExportContent(ReportListResult reportListResult, String subType) {

        StringBuffer sb = new StringBuffer();
        List<String> name = reportListResult.getName();
        List<Object> columnKey = reportListResult.getColumnkey();
        List<String> reportName = reportListResult.getReportname();
        String report = reportName.size() > 0 ? reportName.get(0) : "";

        boolean isNeedChannelAndGroup = SUB_TYPE_CAMPAIGN.equals(subType) && REPORT_NAME_CAMPAIGN.equals(report) || SPECIAL_REPORT_NAME.equals(report);

        if (isNeedChannelAndGroup) {
            name.add("渠道");
            name.add("活动组");
        }

        List<Map<String, Object>> value = reportListResult.getVal();

        if (!CollectionUtils.isEmpty(name)) {

            sb.append(String.join(",", name)).append("\r\n");
            if (isNeedChannelAndGroup) {
                for (Map<String, Object> v : value) {
                    for (int i = 0; i < columnKey.size(); i++) {
                        sb.append(v.get(columnKey.get(i)))
                                .append(columnKey.get(i).toString().startsWith("rate_") ? "%" : "")
                                .append(",");
                    }

                    sb.append(v.containsKey("channelname") ? v.get("channelname") : " ").append(",");
                    sb.append(v.containsKey("groupname") ? v.get("groupname") : " ").append("\r\n");
                }
            } else {
                for (Map<String, Object> v : value) {
                    for (int i = 0; i < columnKey.size(); i++) {
                        sb.append(v.get(columnKey.get(i)))
                                .append(columnKey.get(i).toString().startsWith("rate_") ? "%" : "")
                                .append(i == columnKey.size() - 1 ? "\r\n" : ",");
                    }
                }
            }

        }

        return sb;
    }

    public static StringBuffer getRoiExportContent(ReportListResult result, String name, boolean isFirst) {
        StringBuffer sb = new StringBuffer();
        List<String> nameList = result.getName();
        List<Object> columnKey = result.getColumnkey();
        List<Map<String, Object>> value = result.getVal();

        if (!CollectionUtils.isEmpty(nameList)) {
            if(isFirst){
                sb.append(String.join(",", nameList)).append("\r\n");
            }
            for (Map<String, Object> v : value) {
                sb.append(name).append(",");
                for (int i = 0; i < columnKey.size(); i++) {
                    sb.append(v.get(columnKey.get(i).toString())).append(columnKey.get(i).toString().startsWith("rate_") ? "%" : "")
                            .append(i == columnKey.size() - 1 ? "\r\n" : ",");
                }
            }
        }

        return sb;
    }
}
