package com.reyun.util;

import com.google.common.collect.Maps;
import net.sourceforge.pinyin4j.PinyinHelper;
import net.sourceforge.pinyin4j.format.HanyuPinyinCaseType;
import net.sourceforge.pinyin4j.format.HanyuPinyinOutputFormat;
import net.sourceforge.pinyin4j.format.HanyuPinyinToneType;
import net.sourceforge.pinyin4j.format.HanyuPinyinVCharType;
import net.sourceforge.pinyin4j.format.exception.BadHanyuPinyinOutputFormatCombination;

import java.util.Map;

/**
 * 拼音工具类
 * 
 */
public class PinYinUtil {
    private static Map<String, String> areainfo = Maps.newHashMap();

    static {
        areainfo.put("Anhui", "安徽");
        areainfo.put("Beijing", "北京");
        areainfo.put("Fujian", "福建");
        areainfo.put("Gansu", "甘肃");
        areainfo.put("Guangdong", "广东");
        areainfo.put("Guangxi Zhuang Autonomous Region", "广西");
        areainfo.put("Guizhou", "贵州");
        areainfo.put("Hainan", "海南");
        areainfo.put("Hebei", "河北");
        areainfo.put("Henan", "河南");
        areainfo.put("Heilongjiang", "黑龙江");
        areainfo.put("Hubei", "湖北");
        areainfo.put("Hunan", "湖南");
        areainfo.put("Jilin", "吉林");
        areainfo.put("Jiangsu", "江苏");
        areainfo.put("Jiangxi", "江西");
        areainfo.put("Liaoning", "辽宁");
        areainfo.put("Inner Mongolia Autonomous Region", "内蒙古自治区");
        areainfo.put("Ningxia", "宁夏");
        areainfo.put("Qinghai", "青海");
        areainfo.put("Shandong", "山东");
        areainfo.put("Shanxi", "山西");
        areainfo.put("Shaanxi", "陕西");
        areainfo.put("Shanghai", "上海");
        areainfo.put("Sichuan", "四川");
        areainfo.put("Tianjin", "天津");
        areainfo.put("Tibet", "西藏");
        areainfo.put("Xinjiang", "新疆");
        areainfo.put("Yunnan", "云南");
        areainfo.put("Zhejiang", "浙江");
        areainfo.put("Chongqing", "重庆");
        areainfo.put("Macao", "澳门");
        areainfo.put("HongKong", "青海");
        areainfo.put("Taiwan", "台湾");
    }

    /**
     * 将字符串中的中文转化为拼音,其他字符不变
     * 
     * @param inputString
     * @return
     */
    public static String getPingYin(String inputString) {
        HanyuPinyinOutputFormat format = new HanyuPinyinOutputFormat();
        format.setCaseType(HanyuPinyinCaseType.LOWERCASE);
        format.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
        format.setVCharType(HanyuPinyinVCharType.WITH_V);
 
        char[] input = inputString.trim().toCharArray();
        String output = "";
 
        try {
            for (int i = 0; i < input.length; i++) {
                if (java.lang.Character.toString(input[i]).matches("[\\u4E00-\\u9FA5]+")) {
                    String[] temp = PinyinHelper.toHanyuPinyinStringArray(input[i], format);
                    output += temp[0];
                } else
                    output += java.lang.Character.toString(input[i]);
            }
        } catch (BadHanyuPinyinOutputFormatCombination e) {
            e.printStackTrace();
        }
        return output;
    }
    /**  
     * 获取汉字串拼音首字母，英文字符不变  
     * @param chinese 汉字串  
     * @return 汉语拼音首字母  
     */  
    public static String getFirstSpell(String chinese) {   
            StringBuffer pybf = new StringBuffer();   
            char[] arr = chinese.toCharArray();   
            HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();   
            defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);   
            defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);   
            for (int i = 0; i < arr.length; i++) {   
                    if (arr[i] > 128) {   
                            try {   
                                    String[] temp = PinyinHelper.toHanyuPinyinStringArray(arr[i], defaultFormat);   
                                    if (temp != null) {   
                                            pybf.append(temp[0].charAt(0));   
                                    }   
                            } catch (BadHanyuPinyinOutputFormatCombination e) {   
                                    e.printStackTrace();   
                            }   
                    } else {   
                            pybf.append(arr[i]);   
                    }   
            }   
            return pybf.toString().replaceAll("\\W", "").trim();   
    }   
    /**  
     * 获取汉字串拼音，英文字符不变  
     * @param chinese 汉字串  
     * @return 汉语拼音  
     */  
    public static String getFullSpell(String chinese) {   
            StringBuffer pybf = new StringBuffer();   
            char[] arr = chinese.toCharArray();   
            HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();   
            defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);   
            defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);   
            for (int i = 0; i < arr.length; i++) {   
                    if (arr[i] > 128) {   
                            try {   
                                    pybf.append(PinyinHelper.toHanyuPinyinStringArray(arr[i], defaultFormat)[0]);   
                            } catch (BadHanyuPinyinOutputFormatCombination e) {   
                                    e.printStackTrace();   
                            }   
                    } else {   
                            pybf.append(arr[i]);   
                    }   
            }   
            return pybf.toString();   
    }
    
    /**  
     * 获取汉字串拼音首字母，英文字符不变  
     * @param chinese 汉字串  
     * @return 汉语拼音首字母  
     */  
	public static String getFirstCharSpell(String chinese) {
		StringBuffer pybf = new StringBuffer();
		char[] arr = chinese.toCharArray();
		if (arr.length > 0) {
			HanyuPinyinOutputFormat defaultFormat = new HanyuPinyinOutputFormat();
			defaultFormat.setCaseType(HanyuPinyinCaseType.LOWERCASE);
			defaultFormat.setToneType(HanyuPinyinToneType.WITHOUT_TONE);
			if (arr[0] > 128) {
				try {
					String[] temp = PinyinHelper.toHanyuPinyinStringArray(
							arr[0], defaultFormat);
					if (temp != null) {
						pybf.append(temp[0].charAt(0));
					}
				} catch (BadHanyuPinyinOutputFormatCombination e) {
					e.printStackTrace();
				}
			} else {
				pybf.append(arr[0]);
			}
			return pybf.toString().replaceAll("\\W", "").trim();
		} else {
			return null;
		}
	}

    public static String getProvinceCHNFromPinyin(String pinyin){
        if(areainfo.containsKey(pinyin)){
            return areainfo.get(pinyin);
        }
        return null;
    }
}
