package com.reyun.util;

import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.Pipeline;
import redis.clients.jedis.Response;
import redis.clients.jedis.exceptions.JedisConnectionException;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;

/**
 * 单节点Jedis pipeline.
 * 
 * @author Administrator
 * 
 */
public class RedisUtilPipeline {
	protected Logger logger = LoggerFactory.getLogger(RedisUtilPipeline.class);
	private static RedisUtilPipeline instance;
	private Jedis jedis;
	private static JedisPool pool;

	private RedisUtilPipeline() {
	}

	public static RedisUtilPipeline getInstance() {
		if (null == instance) {
			syncInit();
		}
		return instance;
	}

	private static synchronized void syncInit() {
		if (instance == null) {
			ResourceBundle resourceBundle = ResourceBundle.getBundle("redis");
			GenericObjectPoolConfig config = new GenericObjectPoolConfig();
			config.setTestOnBorrow(true);
			pool = new JedisPool(
					config,
					resourceBundle.getString("redis.surl.host"),
					Integer.valueOf(resourceBundle.getString("redis.surl.port")),
					5000);
			instance = new RedisUtilPipeline();
		}
	}

	public Set<String> hgetAll(String key) {
		Jedis jedis = null;
		Set<String> result = null;
		try {
			jedis = pool.getResource();
			Pipeline p = jedis.pipelined();
			Response<Set<String>> set = p.smembers(key);
			p.sync();
			pool.returnResource(jedis);
			result = set.get();
		} catch (JedisConnectionException e) {
			logger.error(e.getMessage(), e);
			if (null != jedis) {
				pool.returnBrokenResource(jedis);
			}
			throw new JedisConnectionException(e);
		}
		System.out.println(result);
		return result;
	}

	public void pipelineSet() {
		long start = System.currentTimeMillis();
		Jedis jedis = null;
		try {
			jedis = pool.getResource();
			Map<String, String> data = new HashMap<String, String>();
			Pipeline p = jedis.pipelined();
			for (int i = 0; i < 1000; i++) {
				data.clear();
				data.put("kk_" + i, "v_" + i);
				p.hmset("keyk_" + i, data);
			}

			// p.sync();
			List<Object> objs = p.syncAndReturnAll();
			pool.returnResource(jedis);
		} catch (JedisConnectionException e) {
			logger.error(e.getMessage(), e);
			if (null != jedis) {
				pool.returnBrokenResource(jedis);
			}
			throw new JedisConnectionException(e);
		}
		long end = System.currentTimeMillis();
		System.out.println("dbsize:[" + jedis.dbSize() + "] .. ");
		System.out.println("hmset with pipeline used [" + (end - start) / 1000
				+ "] seconds ..");
	}

	public void pipelineSet(List<Map<String, String>> list) {
		Jedis jedis = null;
		try {
			jedis = pool.getResource();
			Pipeline p = jedis.pipelined();
			for (Map<String, String> map : list) {
				String surl = map.get("surl");
				map.remove("surl");
				p.hmset(String.format("surl_%s", surl), map);
			}

			// p.sync();
			List<Object> objs = p.syncAndReturnAll();
			pool.returnResource(jedis);
		} catch (JedisConnectionException e) {
			logger.error(e.getMessage(), e);
			if (null != jedis) {
				pool.returnBrokenResource(jedis);
			}
			throw new JedisConnectionException(e);
		}
	}


	public static void main(String[] args) {
//		RedisUtilPipeline.getInstance().pipelineSet();
		RedisUtilPipeline.getInstance().hgetAll("surl_JzmEje");
      }

}
