package com.reyun.util;

import com.reyun.context.AppUtils;
import com.reyun.model.Event4Web;
import com.reyun.service.EventService;
import com.reyun.service.EventStatsService;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.lang.StringUtils;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * Created by zxy on 2017/9/14.
 */
public class SizheTool {


    public Map getMap() {
        Map<String, String> map = new HashedMap();
        map.put("注册", "reged");
        map.put("app", "app");
        map.put("campaign", "campaign");
        return map;
    }


    public static void main(String[] args) {
        SizheTool tool = new SizheTool();
        try {
            List<String> list = jisuanStr("(注册1.country.count+app.country.count)*3-campaign.count/campaign.countuser", tool.getMap());
            String str = StringUtils.join(list.toArray());
            System.out.println(str);
        } catch (Exception e) {
            System.out.println("请检查你的算式格式");
            e.printStackTrace();
        }
    }



    /**
     * 计算<br>
     * 步骤：1、如果有括号<br>
     * 然后取上一个最近的(坐标 计算当前括号组合里的算式 ），在继续往下查找括号 以此类推,直至循环使用到所有坐标元素
     * 计算完毕（运算顺序括号、乘除、加减）
     *
     * @param str
     * @return
     */
    public static List<String> jisuanStr(String str, Map<String, String> map) throws Exception {
        double returnDouble = 0;
//        List<String> listSplit = splitStr(str); // 拆分好的元素


        List<String> listSplitResult = new ArrayList<String>();
        List<String> listSplit = new ArrayList<String>();
        Matcher matcher = Pattern.compile("\\-?[\\w\\u4e00-\\u9fa5（）]+(\\.[\\w\\u4e00-\\u9fa5（）]+){1,2}|[+*/()]|\\-|\\d")
                .matcher(str);// 用正则拆分成每个元素
        Pattern p1 = Pattern.compile("\\-?\\d+(\\.\\d+)?|[+*/()]|\\-");
        while (matcher.find()) {
            String mid = matcher.group(0);
            System.out.println(mid + "------" + p1.matcher(mid).matches());
            if (p1.matcher(mid).matches()) {
                listSplitResult.add(mid);
                listSplit.add(mid);
            }
            else {
                String[] arrays = mid.split("\\.");
                StringBuffer sb = new StringBuffer();
                boolean isNegative = false;
                if (arrays.length > 1) {
                    if (arrays[0].startsWith("-")) {
                        isNegative = true;
                        if (map.get(arrays[0].substring(1)) == null) {
                            throw new Exception();
                        }
                        sb.append("-" + map.get(arrays[0].substring(1)));
                    } else {
                        if (map.get(arrays[0]) == null) {
                            throw new Exception();
                        }
                        sb.append(map.get(arrays[0]));
                    }

                }
                for (int i=1; i<arrays.length; i++) {
                    sb.append(".").append(arrays[i]);
                }
                listSplitResult.add(sb.toString());
                if (isNegative) {
                    listSplit.add("-1");
                } else {
                    listSplit.add("1");
                }

            }
            System.out.println(listSplit);
//            listSplit.add(matcher.group(0));
        }
        System.out.println(listSplit);
        List<Integer> zKuohaoIdxList = new ArrayList<Integer>();// 左括号,<所在坐标，>
        if (Pattern.compile(".*\\(|\\).*").matcher(str).find()) {// 如果包含括号运算
            String value = "";// 单个字符值
            int zIdx = 0;// 上一个左括号在zKuoHaoIdxList的下标
            // 此层循环计算完所有括号里的算式
            List<String> tempList = new ArrayList<String>();// 前面没有计算的元素
            int removeL = 0;
            int tempListSize = 0;
            for (int i = 0; i < listSplit.size(); i++) {
                value = listSplit.get(i);
                tempList.add(value);
                tempListSize = tempList.size();
                if ("(".equals(value)) {// 左括号
                    zKuohaoIdxList.add(tempListSize-1);
                } else if (")".equals(value)) {// 遇到右括号就计算与上一左括号间的算式
                    zIdx = zKuohaoIdxList.size() - 1;// 离当前右括号最近的左括号配对
                    int start = zKuohaoIdxList.get(zIdx);
                    returnDouble = jisuan(tempList, start + 1, tempListSize-1); // 开始位置,就是上一个左括号
                    removeL = tempListSize - start;
                    tempList = removeUseList(tempList, removeL);// 移除已使用的元素
                    tempList.add(returnDouble + "");// 刚刚计算的值添加进来
                    zKuohaoIdxList.remove(zIdx);// 计算完毕清除括号
                }
            }
            // 把所有计算完
            returnDouble = jisuan(tempList, 0, tempList.size());
        } else {// 没有括号运算
            returnDouble = jisuan(listSplit, 0, listSplit.size());
        }
        System.out.println(returnDouble);
        return listSplitResult;
    }

    /**
     * 倒序删除已用过的元素
     *
     * @param list
     * @param removeLength
     *            数量
     * @return
     */
    public static List<String> removeUseList(List<String> list, int removeLength) {
        int le = list.size() - removeLength;
        for (int i = list.size() - 1; i >= le; i--) {
            list.remove(i);
        }
        return list;
    }

    /**
     * 计算算式
     *
     * @param listSplit
     * @param start
     *            括号算式开始符位置
     * @param end
     *            括号结束符位置
     * @return
     */
    public static double jisuan(List<String> listSplit, int start, int end)
            throws Exception {
        double returnValue = 0;
        String strValue = null;// 临时变量
        List<String> jjValueList = new ArrayList<String>();// 剩下的加减元素
        // 遍历计算乘除法
        for (int i = start; i < end; i++) {
            strValue = listSplit.get(i);
            if ("*".equals(strValue) || "/".equals(strValue)) {// 乘除
                strValue = jisuanValue("*".equals(strValue) ? "*" : "/", Double
                                .parseDouble(jjValueList.get(jjValueList.size() - 1)),
                        Double.parseDouble(listSplit.get(i + 1)))
                        + "";
                jjValueList.remove(jjValueList.size() - 1);
                i++;
            }
            jjValueList.add(strValue);
        }
        // 遍历计算加减
        for (int j = 0; j < jjValueList.size(); j++) {
            strValue = jjValueList.get(j);
            if ("-".equals(strValue) || "+".equals(strValue)) {
                returnValue = jisuanValue("-".equals(strValue) ? "-" : "+",
                        returnValue, Double.parseDouble(jjValueList.get(j + 1)));
                j++;
            } else {
                returnValue += Double.parseDouble(jjValueList.get(j));
            }
        }
        return returnValue;
    }

    /**
     * 计算2个数间的加减乘除操作 如：2*5 ，2/5
     *
     * @param type
     *            运算符
     * @param start
     *            数 相当于上面2
     * @param end
     *            被数 相当于上面5
     * @return
     */
    public static double jisuanValue(String type, double start, double end)
            throws Exception {
        double d = 0;
        if ("-".equals(type)) {
            d = start - end;
        } else if ("+".equals(type)) {
            d = start + end;
        } else if ("*".equals(type)) {
            d = start * end;
        } else if ("/".equals(type)) {
            if (0 == start || 0 == end)
                d = 0;
            else
                d = start / end;
        }
        return d;
    }

}
