(function(){
	angular.module("app")
		.directive("myDatepicker",["ToolService","DateService","UtilService",myDatepicker])
		.directive("singleDatepicker",singleDatepicker)
		.directive("myDateweek",['UtilService',myDateweek])
		.directive("myDatemonth",['UtilService',myDatemonth]);

		var tempVersion = new Date().getTime();
		/*日期 多日期*/
		function myDatepicker(ToolService,DateService,UtilService) {
		    var today = Date.today();
		    var defaultOpsn = {
		        abbrWeeks: ['日', '一', '二', '三', '四', '五', '六'],
		        format: 'YYYY-MM-DD',
		        min: null,
		        max: today,
		        start: today,
		        end: today,
		        current: today,
		        months: 2, //默认显示2个面板
		        chooseCls: 'is-choose',
		        todayCls: 'is-today'
		    };

		    return {
		        restrict: 'EA',
		        transclude: true,
		        replace:true,
		        templateUrl: '/template/common/datepicker.html?r='+tempVersion,
		        scope: {
		            dateName:'@', //日期传递名称
		            noMax:"@", //是否有最大日期限制
		            rangeDays:"@", //最多日期范围 -1:不需要控制范围
		            rangeDays2:"=", //最多日期范围,动态
		            initDay:"=", //初始化显示日期
		            maxDay:'@',  //最大日期选择，默认为今天，-1为昨天。。。
		            maxDay2:"=", //同上，动态传参
		            operationSel:"=", //当前可否操作
		            min:"="
		        },
		        link: function(scope, elem, attrs) {
		        	scope.maxDay = scope.maxDay || scope.maxDay2;

		        	var ddd = -1;
		        	if(UtilService.isNullStr(scope.maxDay)){
		        		ddd = 0;
		        	}
		        	var cacheDates = {
		            	'yesday':DateService.getYesDay(),
		            	'd7':DateService.getLastDays(-7,ddd),
		            	'd14':DateService.getLastDays(-14,ddd),
		            	'd30':DateService.getLastDays(-30,ddd),
		            	'-w1':DateService.getWeekRangeDate(-1,ddd),
		            	'w0':DateService.getWeekRangeDate(0,ddd),
		            	'-m1':DateService.getMonthRangeDate(-1,ddd),
		            	'm0':DateService.getMonthRangeDate(0,ddd)
		            }
		            scope.$watch("operationSel",function(n){
		             	if(angular.isUndefined(scope.operationSel)){
			             	scope.operSel = true;
			            }
			            else{
			            	scope.operSel = n;
			            }
		            });
		            //根据选择日期设置相对时间范围flag
		            scope.getRelativeFlag = function(startDate,endDate){
		            	var relFlag = "";
		            	for(var k in cacheDates){
	                		var range = cacheDates[k];
	                		if(startDate == range.startDate && endDate == range.endDate){
	                			relFlag = k;
	                			break;
	                		}
	                	}
	                	scope.selDayflag = relFlag;
		            }
		            //把初始化日期赋值到日期框里面
		            scope.$watch("initDay",function(n){
		            	if(angular.isDefined(n) && n.startDate){
		            		if(!scope.options.start.isSameDay(new Date(n.startDate)) || !scope.options.end.isSameDay(new Date(n.endDate))){
		            			scope.getRelativeFlag(n.startDate,n.endDate);
			            		scope.options.start = scope.completeStrat = new Date(n.startDate);
			            		scope.options.end = scope.completeEnd = new Date(n.endDate);
		            		}
		            	}
		            });
		        	scope.selme = false;
		        	scope.$watch("rangeDays+rangeDays2",function(e){
		        		var rds = scope.rangeDays || scope.rangeDays2;
		        		if(angular.isDefined(rds)){
			        		scope.rgDays = Number(rds);
			        	}else{
			        		scope.rgDays = 31;
			        	}
		        	});
		        	
		            var maxTime = today,emitName = scope.dateName || "dateCustos";
		            if(scope.maxDay && scope.maxDay == -1){
		            	maxTime = Date.yesterday();
		            }
		            //如果最大可选日期不是当天，则在当前年上加上100年
		            if(scope.noMax && scope.noMax == 'true'){
		                var future = Date.today();
		                future.setFullYear(today.getFullYear()+100);
		                maxTime = future;
		            }

		            var minTime = "";
		            scope.$watch("min",function(n){
		            	if(angular.isDefined(n)){
		            		minTime = new Date(n).addDays(-1);
		            	}
		            });
		            var defaultOps = UtilService.cloneJSON(defaultOpsn);
		            var setOption = function() {
		                defaultOps.start = maxTime;
		                defaultOps.end = maxTime;
		                defaultOps.max = maxTime;
		                defaultOps.current = today;
		                scope.options = angular.extend(defaultOps, scope.options || {});
		                //清除时分秒毫秒
		                scope.options.start.clearTime();
		                scope.options.end.clearTime();

		                scope.completeStrat = scope.options.start;
		                scope.completeEnd = scope.options.end;
		                scope.customStrat = scope.options.start.toFormat(scope.options.format);
		                scope.customEnd = scope.options.end.toFormat(scope.options.format);

		                //最后一个日期面板的日期
		                scope.panelEndDate = Date.getFirstDay(scope.options.end); 
		            };
		            setOption();
		            var render = function(date) {
		                var panels = [],
		                    months = scope.options.months,
		                    date = (date || scope.panelEndDate).clone();
		                for (var p = 0; p < months; p++) {
		                    var weeks = [],
		                        dateOfPanel = date.clone().addMonths(-(months - 1 - p)), //每个日期面板的日期
		                        firstDay = Date.getFirstDay(dateOfPanel), //该月的第一天
		                        firstWeekDay = firstDay.getDay(), //该月的一个星期
		                        daysOfMonth = Date.getDaysInMonth(dateOfPanel.getFullYear(), dateOfPanel.getMonth()), //该月有几天
		                        rowNums = Math.ceil((firstWeekDay + daysOfMonth) / 7), //该月日历的行数
		                        curDate = firstDay.clone().addDays(-firstWeekDay); //循环遍历的日期

		                    for (var i = 0; i < rowNums; i++) {
		                        // weeks.push([])
		                        var days = [];
		                        for (var j = 0; j < 7; j++) {
		                            var tmp = curDate.clone();
		                            days.push({
		                                day: tmp,
		                                choose: tmp.between(scope.options.start, scope.options.end),
		                                other: tmp.getMonth() != dateOfPanel.getMonth(),
		                                today: Date.isSameDay(tmp, today) //是否是今日
		                            });
		                            curDate = curDate.addDays(1);
		                        }

		                        weeks.push(days);
		                    }

		                    panels.push({
		                        date: dateOfPanel,
		                        weeks: weeks
		                    });
		                }
		                //可选最大时间不是今天，禁用"今天，昨天，最近七天按钮，默认显示最大天数"
		                // if (maxTime !== today) {
		                //     scope.complete();
		                //     $(elem).parent().prevAll().hide();
		                // } else {
		                    $(elem).parent().prevAll().show();
		                // }
		                scope.panels = panels;
		                scope.wstyle = {"width":(months*274 + 80)+"px"};
		            };
		            //初始化面板上日期的css
		            scope.cellClass = function(cell) {
		            	if(cell.other){
		            		return "other-month";
		            	}
		            	else if(cell.day.isSameDay(scope.options.start) || cell.day.isSameDay(scope.options.end)){
		            		return "start_end";
		            	}
		            	else if(cell.day.between(scope.options.start, scope.options.end)){
		            		return "choose";
		            	}
		            	else if(cell.day.isSameDay(scope.options.current) && cell.day.isSameDay(maxTime)){
		            		return "is-today";
		            	}
		            	else if(cell.day.isAfter(maxTime) || (minTime!='' && cell.day.isBefore(minTime))){
		            		return "disabled";
		            	}
		            	else{
		            		return "";
		            	}
		            };
		            //切换月份
		            scope.changeMonth = function(index, date, num) {
		                scope.dateMonth = scope.panelEndDate.addMonths(num);
		                render(scope.dateMonth);
		            };
		            //点击显示或隐藏日期面板
		            scope.showDateTable = function() {
		            	if(!scope.operSel){return false;}

		            	var curDateWrap = $(elem).find(".dateTabRange");
		            	$(".dateTabRange").each(function(){
		            		if($(this)!==curDateWrap){
		            			$(this).addClass("ng-hide");
		            		}
		            	});
		            	if(curDateWrap.hasClass("ng-hide")){
		            		scope.showFlag = true;
		            		curDateWrap.removeClass("ng-hide")
		            	}
		            	else{
		            		scope.showFlag = false;
		            		curDateWrap.addClass("ng-hide")
		            	}

		                // if (typeof scope.showFlag == 'undefined') {
		                // 	$(".dateTabRange").addClass("ng-hide");
		                //     scope.showFlag = true;
		                // } else if (scope.showFlag == true) {
		                //     scope.showFlag = false;
		                // } else if (scope.showFlag == false) {
		                // 	$(".dateTabRange").addClass("ng-hide");
		                //     scope.showFlag = true;
		                // }
		            }


		            //选择具体日期
		            var chooseCounts = 0;
		            scope.chooseDate = function(cell) {
		                //是否大于今天
		                // if (cell.day.isAfter(today)) { 
		                //     return;
		                // }
		                //是否大于可选择最大时间
		                if (cell.day.isAfter(maxTime)) { 
		                    return;
		                }
		                //是否小于可选择最小时间
		                if (minTime!='' && cell.day.isBefore(minTime)) { 
		                    return;
		                }
		                if (chooseCounts >= 2) chooseCounts = 0;
		                chooseCounts++;

		                if (chooseCounts === 1) {
		                    scope.options.end = scope.options.start = cell.day;
		                } else if (chooseCounts === 2) {
		                    cell.day.isAfter(scope.options.start) ? scope.options.end = cell.day : scope.options.start = cell.day;
		                }
		            };
		            
		            scope.setRelDate = function(flag){
		            	
		            	var daterange = cacheDates[flag];
		            	if(scope.rgDays!=-1){
		            		var diff = diffDate(daterange.startDate,daterange.endDate);
			            	if(diff > scope.rgDays){
			            		ToolService.showTips("日期范围不能大于"+scope.rgDays+"天");
			            		return false;
			            	}
		            	}

		            	scope.selDayflag = flag;
		            	if(minTime!='' && new Date(daterange.startDate).isBefore(minTime)){
		            		ToolService.showTips("超出最小可选日期限制了");
		            		return;
		            	}
		            	else{
		            		scope.options.start = new Date(daterange.startDate);
		            	}

		            	if(minTime!='' && new Date(daterange.endDate).isBefore(minTime)){
		            		ToolService.showTips("超出最小可选日期限制了");
		            		return;
		            	}
		            	else{
		            		scope.options.end = new Date(daterange.endDate);
		            	}
		            	
		            	scope.complete(1);
		            }
		            //点击确定，完成日期选择，传递日期
		            scope.complete = function(isrel) {
		            	if(angular.isUndefined(isrel) && scope.rgDays!=-1){
		            		var diff = diffDate(scope.options.start,scope.options.end)
			            	if(diff > scope.rgDays){
			            		ToolService.showTips("日期范围不能大于"+scope.rgDays+"天");
			            		return false;
			            	}
		            	}
		            	
		            	scope.completeStrat = scope.options.start;
		                scope.completeEnd = scope.options.end;

		                var startDate = scope.completeStrat.toFormat(scope.options.format),endDate = scope.completeEnd.toFormat(scope.options.format);
		                if(angular.isUndefined(isrel)){
		                	scope.getRelativeFlag(startDate,endDate);
		                	
		                }
		               	scope.$emit(emitName, {"startDate":startDate,"endDate":endDate,"dateflag":scope.selDayflag});
		                
		                scope.showFlag = false;
		            };
		            //取消选择，关闭面板
		            scope.cancel = function() {
		            	if(scope.options.start != scope.completeStrat || scope.options.end != scope.completeEnd){
		            		scope.options.start = scope.completeStrat;
			                scope.options.end = scope.completeEnd;
			                scope.getRelativeFlag(scope.completeStrat.toFormat(scope.options.format),scope.completeEnd.toFormat(scope.options.format));
		            	}
		            	scope.showFlag = false;
		            };
		            //检测选择日期操作
		            scope.$watch('options.start+options.end', function() {
		            	scope.customStrat = scope.options.start.toFormat(scope.options.format);
		                scope.customEnd = scope.options.end.toFormat(scope.options.format);
		            });
		            render();

		            $(document).on("click",function(){
		                scope.cancel();
		                scope.$apply();
		            });
		        }
		    };
		};

		/*单日期控件*/
		function singleDatepicker() {
		    var today = Date.today();
		    var defaultOps = {
		        abbrWeeks: ['日', '一', '二', '三', '四', '五', '六'],
		        format: 'YYYY-MM-DD',
		        min: null,
		        max: today,
		        start: today,
		        end: today,
		        current: today,
		        months: 1, 
		        chooseCls: 'is-choose',
		        todayCls: 'is-today'
		    };

		    return {
		        restrict: 'EA',
		        transclude: true,
		        replace:true,
		        templateUrl: '/template/common/datepicker.html?r='+tempVersion,
		        scope: {
		            dateName:"@",
		            campareDays:"=",
		            operationSel:"=" //当前可否操作
		        },
		        link: function(scope, elem, attrs) {
		        	scope.$watch("operationSel",function(n){
		             	if(angular.isUndefined(scope.operationSel)){
			             	scope.operSel = true;
			            }
			            else{
			            	scope.operSel = n;
			            }
		            });

		             var maxTime = today,emitName = scope.dateName;
		             var setOption = function() {
		                defaultOps.start = maxTime;
		                defaultOps.end = maxTime;
		                defaultOps.max = maxTime;
		                defaultOps.current = maxTime;
		                scope.options = angular.extend(defaultOps, scope.options || {});
		                //清除时分秒毫秒
		                scope.options.start.clearTime();
		                scope.options.end.clearTime();

		                scope.completeStrat = scope.options.start;
		                scope.completeEnd = scope.options.end;
		                scope.customStrat = scope.options.start.toFormat(scope.options.format);
		                scope.customEnd = scope.options.end.toFormat(scope.options.format);

		                //最后一个日期面板的日期
		                scope.panelEndDate = Date.getFirstDay(scope.options.end); 
		            };
		            setOption();
		            var render = function(date) {
		                var panels = [],
		                    months = scope.options.months,
		                    date = (date || scope.panelEndDate).clone();

		                months = 1;
		                for (var p = 0; p < months; p++) {
		                    var weeks = [],
		                        dateOfPanel = date.clone().addMonths(-(months - 1 - p)), //每个日期面板的日期
		                        firstDay = Date.getFirstDay(dateOfPanel), //该月的第一天
		                        firstWeekDay = firstDay.getDay(), //该月的一个星期
		                        daysOfMonth = Date.getDaysInMonth(dateOfPanel.getFullYear(), dateOfPanel.getMonth()), //该月有几天
		                        rowNums = Math.ceil((firstWeekDay + daysOfMonth) / 7), //该月日历的行数
		                        curDate = firstDay.clone().addDays(-firstWeekDay); //循环遍历的日期

		                    for (var i = 0; i < rowNums; i++) {
		                        // weeks.push([])
		                        var days = [];
		                        for (var j = 0; j < 7; j++) {
		                            var tmp = curDate.clone();
		                            days.push({
		                                day: tmp,
		                                choose: tmp.between(scope.options.start, scope.options.end),
		                                other: tmp.getMonth() != dateOfPanel.getMonth(),
		                                today: Date.isSameDay(tmp, today) //是否是今日
		                            });
		                            curDate = curDate.addDays(1);
		                        }

		                        weeks.push(days);
		                    }

		                    panels.push({
		                        date: dateOfPanel,
		                        weeks: weeks
		                    });
		                }
		                //可选最大时间不是今天，禁用"今天，昨天，最近七天按钮，默认显示最大天数"
		                if (maxTime !== today) {
		                    scope.complete();
		                    $(elem).parent().prevAll().hide();
		                } else {
		                    $(elem).parent().prevAll().show();
		                }
		                scope.panels = panels;
		                scope.wstyle = {"width":months*274+"px"};
		            };
		            scope.cellClass = function(cell) {
		                return cell.other ? "other-month" :
		                    cell.day.between(scope.options.start, scope.options.end) ? "choose" :
		                    cell.day.isSameDay(maxTime) ? "is-today" :
		                    cell.day.isAfter(maxTime) ? "disabled" : '';
		            };
		            scope.changeMonth = function(index, date, num) {
		                scope.dateMonth = scope.panelEndDate.addMonths(num);
		                render(scope.dateMonth);
		            };
		            
		            scope.showDateTable = function() {
		            	if(!scope.operSel){return false;}
		            	
		                if (typeof scope.showFlag == 'undefined') {
		                    scope.showFlag = true;
		                } else if (scope.showFlag == true) {
		                    scope.showFlag = false;
		                } else if (scope.showFlag == false) {
		                    scope.showFlag = true;
		                }
		            }

		            var chooseCounts = 0;
		            scope.chooseDate = function(cell) {
		                //是否大于今天
		                if (cell.day.isAfter(today)) { 
		                    return;
		                }
		                //是否大于可选择最大时间
		                if (cell.day.isAfter(maxTime)) { 
		                    return;
		                }
		                if (chooseCounts >= 2) chooseCounts = 0;
		                chooseCounts++;

		                //如果有对比日期，用所选日期-去对比天数=对比开始日期
		                if(angular.isDefined(scope.campareDays) && scope.campareDays>0){
		                    scope.options.end = cell.day;
		                    scope.options.start = new Date(addDate(cell.day,-scope.campareDays));
		                }else{
		                    scope.options.end = scope.options.start = cell.day;
		                }
		                scope.complete();
		            };
		            scope.complete = function() {
		                scope.completeStrat = scope.options.start;
		                scope.completeEnd = scope.options.end;
		              
		                if(angular.isDefined(scope.campareDays) && scope.campareDays>0){
		                    scope.$emit(emitName, scope.completeStrat.toFormat(scope.options.format) + ' - ' + scope.completeEnd.toFormat(scope.options.format));
		                }else{
		                    scope.$emit(emitName, scope.completeStrat.toFormat(scope.options.format));
		                }
		                scope.showFlag = false;
		            };
		            scope.cancel = function() {
		                scope.options.start = scope.completeStrat;
		                scope.options.end = scope.completeEnd;
		                scope.showFlag = false;
		            };
		            scope.$watch('options.start+options.end', function() {
		                scope.customStrat = scope.options.start.toFormat(scope.options.format);
		                scope.customEnd = scope.options.end.toFormat(scope.options.format);
		            });
		            render();

		            $(document).on("click",function(){
		                scope.cancel();
		                scope.$apply();
		            });
		        }
		    };
		};


	/*日期 选择周*/
	function myDateweek(UtilService) {
	    var today = Date.yesterday();

	    return {
	        restrict: 'EA',
	        transclude: true,
	        replace:true,
	        templateUrl: '/template/common/dateweek.html?r='+tempVersion,
	        scope: {
	            dateName:"@",
	            weeks:"@"
	        },
	        link: function(scope, elem, attrs) {
	            scope.options = {};
	            if(scope.weeks){
	                scope.options.weeks = scope.weeks;
	            }else{
	                scope.options.weeks = 1;
	            }

	            scope.showDateTable = function() {
	                if (typeof scope.showFlag == 'undefined') {
	                    scope.showFlag = true;
	                } else if (scope.showFlag == true) {
	                    scope.showFlag = false;
	                } else if (scope.showFlag == false) {
	                    scope.showFlag = true;
	                }
	            }

	            var nyear = scope.nowyear = today.getFullYear();
	            var selectday = today.clone();

	            var nowW = new Date().getDay();
	            nowW = nowW == 0 ? 7 : nowW;
	            scope.options.start = scope.options.end = {
	                week : getNowWeek(),
	                date : new Date().clone().addDays(7 - nowW),
	                year : scope.nowyear
	            }

	            scope.setWeeklist = function(){
	                scope.weeklist = [];
	                var weeknum = 7;
	                var firstDay = new Date(scope.nowyear, 0, 1),fw = firstDay.getDay();
	                var maxDay = new Date(scope.nowyear, 11, 31),rowweek = [];

	                fw = fw == 0 ? 7 :fw;
	                var endDay = firstDay.clone().addDays(7 - fw),w = 0;
	                if(fw > 0 && fw < 5){ //当年的第一天为周五周六周日并到上一年
	                    w = 1;
	                    rowweek.push({
	                        week : w,
	                        // date : endDay.toFormat("YYYY-MM-DD"),
	                        date : endDay,
	                        year : scope.nowyear
	                    });
	                }

	                while(endDay < maxDay && !maxDay.isSameDay(endDay)){
	                    w ++ ;
	                    endDay = endDay.clone().addDays(7);
	                    rowweek.push({
	                        week : w,
	                        // date : endDay.toFormat("YYYY-MM-DD"),
	                        date : endDay,
	                        year : scope.nowyear
	                    });

	                    if(w % weeknum == 0){
	                        scope.weeklist.push(rowweek);
	                        rowweek = [];
	                    }
	                }
	   
	                var lastDay = new Date(scope.nowyear, 11, 31),lastW = lastDay.getDay();
	                //当年最后一天是周五周六或者周日时，移到下一年
	                if(lastW > 0 && lastW < 4){
	                    if(rowweek.length == 0){
	                        scope.weeklist[scope.weeklist.length-1].pop();
	                    }else{
	                        rowweek.pop();
	                    }
	                }

	                if(rowweek.length > 0){
	                    scope.weeklist.push(rowweek);
	                }
	            }

	            scope.changeYear = function(n){
	                scope.nowyear+=n;
	                scope.setWeeklist();
	            }
	            scope.setWeeklist();

	            var chooseCounts = 0;
	            scope.chooseDate = function(cell) {
	                if(cell.date.clone().addDays(-6).isAfter(today)){
	                    return false;
	                }
	                if(scope.options.weeks == 1){
	                    selectday = cell.date;
	                    scope.options.start = scope.options.end = cell;
	                    scope.$emit(scope.dateName,cell.year+""+getStr(cell.week));
	                    scope.cancel();
	                }else{ //2
	                    if (chooseCounts >= 2) chooseCounts = 0;
	                    chooseCounts++;

	                    if(chooseCounts == 1){
	                        scope.options.start = scope.options.end = cell;
	                    }else{
	                        var preCell = scope.options.start;
	                        if(preCell.date > cell.date){
	                            scope.options.start = cell;
	                        }else{
	                            scope.options.end = cell;
	                        }
	                    }
	                }
	                
	            }
	            scope.complete = function(){
	                var start = scope.options.start.year + "" + UtilService.getStr(scope.options.start.week);
	                var end = scope.options.end.year + "" + UtilService.getStr(scope.options.end.week);
	                scope.$emit(scope.dateName,{start:start,end:end});
	                scope.cancel();
	            }
	            scope.cellClass = function(cell) {
	                if(cell.date.between(scope.options.start.date,scope.options.end.date)){
	                    return "choose";
	                }
	                else if((cell.year == scope.options.start.year && cell.week == scope.options.start.week) || (cell.year == scope.options.end.year && cell.week == scope.options.end.week)){
	            		return "start_end";
	            	}
	                else if(today.between(cell.date.clone().addDays(-6),cell.date)){
	                    return "is-now";
	                }
	                else if(cell.date.isAfter(today)){
	                    return "disabled";
	                }
	                else{
	                    return '';
	                }
	            };
	            scope.cancel = function() {
	                scope.showFlag = false;
	            };

	            $(document).on("click",function(){
	                scope.cancel();
	                scope.$apply();
	            });
	        }
	    };
	};
	/*日期 选择月*/
	function myDatemonth(UtilService) {
	    var today = Date.yesterday();
	    return {
	        restrict: 'EA',
	        transclude: true,
	        replace:true,
	        templateUrl: '/template/common/datemonth.html?r='+tempVersion,
	        scope: {
	            dateName:"@",
	            months:"@"
	        },
	        link: function(scope, elem, attrs) {
	            var nyear = scope.nowyear = today.getFullYear();
	            var selectmonth = scope.nowMonth = today.getMonth() + 1;

	            scope.options = {};
	            if(scope.months){
	                scope.options.months = scope.months;
	            }else{
	                scope.options.months = 1;
	            }
	           
	            scope.showDateTable = function() {
	                if (typeof scope.showFlag == 'undefined') {
	                    scope.showFlag = true;
	                } else if (scope.showFlag == true) {
	                    scope.showFlag = false;
	                } else if (scope.showFlag == false) {
	                    scope.showFlag = true;
	                }
	            }
	            scope.changeYear = function(n){
	                scope.nowyear+=n;
	                scope.setmonthList();
	            }
	            scope.setmonthList = function(){
	                scope.monthList = [];
	                var rowNums = 4,row = [];
	                for(var i=1;i<=12;i++){
	                    row.push({
	                        month : i,
	                        year : scope.nowyear,
	                        date : new Date(scope.nowyear,i-1,1)
	                    });

	                    if(angular.isUndefined(scope.options.start) && i == selectmonth && scope.nowyear == nyear){
	                        scope.options.start = scope.options.end = row.slice(-1)[0];
	                    }

	                    if(i%rowNums == 0){
	                        scope.monthList.push(row);
	                        row = [];
	                    }
	                }
	            }
	            scope.setmonthList();

	            var chooseCounts = 0;
	            scope.chooseDate = function(cell) {
	                if(cell.year > nyear || (cell.month > scope.nowMonth && cell.year == nyear)){
	                    return false;
	                }

	                if(scope.options.months == 1){
	                    selectmonth = cell.month;
	                    scope.options.start = scope.options.end = cell;
	                    scope.$emit(scope.dateName,cell.year+""+ UtilService.getStr(cell.month));
	                    scope.cancel();
	                }else{ //2
	                    if (chooseCounts >= 2) chooseCounts = 0;
	                    chooseCounts++;

	                    if(chooseCounts == 1){
	                        scope.options.start = scope.options.end = cell;
	                    }else{
	                        var preCell = scope.options.start;
	                        if(preCell.year > cell.year || (preCell.year == cell.year && preCell.month > cell.month)){
	                            scope.options.start = cell;
	                        }else{
	                            scope.options.end = cell;
	                        }
	                    }
	                }
	            }
	            scope.complete = function(){
	                var start = scope.options.start.year + "" + UtilService.getStr(scope.options.start.month);
	                var end = scope.options.end.year + "" + UtilService.getStr(scope.options.end.month);
	       
	                scope.$emit(scope.dateName,{start:start,end:end});
	                scope.cancel();
	            }
	            scope.cellClass = function(cell) {
	                if(cell.date.between(scope.options.start.date,scope.options.end.date)){
	                    return "choose";
	                }
	                else if(cell.month == scope.nowMonth && cell.year == nyear){
	                    return "is-today";
	                }
	                else if(cell.year > nyear || (cell.month > scope.nowMonth && cell.year == nyear)){
	                    return "disabled";
	                }
	                else{
	                    return '';
	                }
	            };
	            scope.cancel = function() {
	                scope.showFlag = false;
	            };
	            $(document).on("click",function(){
	                scope.cancel();
	                scope.$apply();
	            });
	        }
	    };
	};
})();