(function () {
    'use strict';
    
    angular.module("app")
    .factory("DateService",DateService);

    function DateService(){
    	var service = {};
    	 
        /*0今天，-1昨天。。。*/
        service.getDay = function(num){
            var time = new Date(),
                    dayFn = function(date) {
                        var YY = date.getFullYear(),
                            MM = date.getMonth() + 1,
                            DD = date.getDate();
                        if (MM < 10) MM = "0" + MM;
                        if (DD < 10) DD = "0" + DD;
                        return YY + "-" + MM + "-" + DD
                    },
                    times = time.getTime() + (1000 * 60 * 60 * 24 * num);

            time.setTime(times);
            
            return dayFn(time);
        };

        //一年多少周
        service.getYearWeekList = function(year){
            if(typeof year == 'undefined'){
                var d = new Date();
                year = d.getFullYear();
            }

            var weeklist = [];
            var firstDay = new Date(year, 0, 1),fw = firstDay.getDay();
            var maxDay = new Date(year, 11, 31);

            fw = fw == 0 ? 7 :fw;
            var endDay = firstDay.clone().addDays(7 - fw),w = 0;
            //当年的第一天为周五周六周日并到上一年
            if(fw > 0 && fw < 5){ 
                w = 1;
                weeklist.push({
                    week : w,
                    date : endDay,
                    year : year
                });
            }

            while(endDay < maxDay && !maxDay.isSameDay(endDay)){
                w ++ ;
                endDay = endDay.clone().addDays(7);
                weeklist.push({
                    week : w,
                    date : endDay,
                    year : year
                });
            }

            var lastDay = new Date(year, 11, 31),lastW = lastDay.getDay();
            //当年最后一天是周五周六或者周日时，移到下一年
            if(lastW > 0 && lastW < 4){
                weeklist.pop();
            }
            return weeklist;
        }

        //一年多少周数
        service.getYearWeekCount = function(year){
            return service.getYearWeekList(year).length;
        }

        //当前周数
        service.getNowWeekNum = function(){
            var today = Date.today();
            var firstDay = new Date(today.getFullYear(), 0, 1),fw = firstDay.getDay();
            var endDay = firstDay.clone(),n = 0;
            if( fw > 0){
                endDay = endDay.addDays(8-fw);
                n = 1;
            }
            var days = diffDate(endDay , today);
            return Math.ceil(days/7) + n;
        }
        //今天
        service.getToday = function(){
            return {
                startDate:service.getDay(0),
                endDate:service.getDay(0)
            }
        }
        //昨天
        service.getYesDay = function(){
            return {
                startDate:service.getDay(-1),
                endDate:service.getDay(-1)
            }
        }
        //最近几天，默认从昨天往前推
        service.getLastDays = function(d,flag){
            if(angular.isUndefined(flag)){
                flag = -1;
            }
            if(flag == 0 && d<0){
                d += 1;
            }
            if(flag == 0 && d>0){
                d -= 1;
            }
            return {
                startDate:service.getDay(d),
                endDate:service.getDay(flag)
            }
        }
        //最近几周
        service.getLastWeeks = function(d){
            var w = service.getNowWeekNum(),
                date = new Date(),
                year = date.getFullYear();

            var range = {end:year+service.getStr(w)},pd = d + w +1;
            if(pd > 0 ){
                range.start = year + service.getStr(pd);
            }else{
                var pr = service.getYearWeekCount(year-1);
                range.start = (year-1) + service.getStr(pr + pd);
            }
            return range;
        }
        //最近几月
        service.getLastMonths = function(d){
            var date = new Date(),year = date.getFullYear(),month = date.getMonth()+1;

            var range = {end:year+service.getStr(month)},pm = month+d+1;
            if(pm > 0 ){
                range.start = year + service.getStr(pm);
            }else{
                range.start = (year-1) + service.getStr(12 + pm);
            }
            return range;
        }
        service.getStr = function(n){ 
            if(n < 10){
                return "0"+n;
            }else{
                return n+"";
            }
        }

        //某周日期范围 d:0当前周 -1往前 1往后  
        //flag传值就是最大天数是昨天 目前传-1表示最大昨天
        service.getWeekRangeDate = function(d,flag){
            d = d ? d : 0;
            var date = new Date(),w = date.getDay();
            w = w == 0 ? 7 : w;

            var start = date.clone().addDays(-w+1),end = date;

            if(d > 0){
                start = start.clone().addDays(d*7);
                end = start.clone().addDays(6);
            }
            else if(d < 0){
                end = start.clone().addDays(-1+(d+1)*7);
                start = start.clone().addDays(d*7);
            }

            if(flag && flag == -1 && Date.isSameDay(end,Date.today())){
                if(start == end){
                    start = end = end.clone().addDays(-1);
                }
                else{
                    end = end.clone().addDays(-1);
                }
            }
            return {
                startDate:start.Format("yyyy-MM-dd"),
                endDate:end.Format("yyyy-MM-dd")
            }
        }

        //某月日期范围 d:0当前月 -1往前 1往后  
        //flag传值就是最大天数是昨天 目前传-1表示最大昨天
        service.getMonthRangeDate = function(d,flag){
            d = d ? d : 0;
            var date = new Date(),year = date.getFullYear(),m = date.getMonth(),day = date.getDate();
            var start = null,end = null;
            if(d!=0){
                m += d;
                if(m<0){
                    m += 11;
                    -- year;
                }
                day = Date.getDaysInMonth(year,m);
                end = new Date(year,m,day);

                start = end.clone();
                start.setDate(1);
            }
            else{
                if(flag && flag == -1){
                    day += -1;
                }
                start = date.clone(),end = date;
                start.setDate(1);
                end.setDate(day);
            }

            return {
                startDate:start.Format("yyyy-MM-dd"),
                endDate:end.Format("yyyy-MM-dd")
            }
        }
        //计算两个日期时间差
        service.getDaysNum = function(strDateStart,strDateEnd){
            var strSeparator = "-"; //日期分隔符
            var oDate1;
            var oDate2;
            var iDays;
            oDate1= strDateStart.split(strSeparator);
            oDate2= strDateEnd.split(strSeparator);
            var strDateS = new Date(oDate1[0], oDate1[1]-1, oDate1[2]);
            var strDateE = new Date(oDate2[0], oDate2[1]-1, oDate2[2]);
            iDays = parseInt(Math.abs(strDateS - strDateE ) / 1000 / 60 / 60 /24)//把相差的毫秒数转换为天数 
            return iDays;
        }

    	return service;
    }
})();