(function(){
	var tempVersion = new Date().getTime();
	
	angular.module("app")
	.directive("profileItem",["ToolService","UtilService","HttpService","$rootScope",profileItem]);

	function profileItem(ToolService,UtilService,HttpService,$rootScope){
		return {
            restrict: "E",
            templateUrl : '/template/common/profileItem.html?r='+tempVersion,
            scope:{
                infoList:"=", //属性列表
                itemId:"=",
                itemInfo:"=", //当前item数据
                itemType:"@",
                itemEvent:"=",
                common:"@" //true为通用属性
            },
            link: function($scope, el) {
            	$scope.stringList = ToolService.getStringTypes();
            	$scope.numberList = ToolService.getNumberTypes();
            	$scope.initdate = ToolService.getToday();
            	
            	var hasInfo = {};
            	if(angular.isDefined($scope.itemInfo)){
            		hasInfo = UtilService.cloneJSON($scope.itemInfo);
            	}
            	$scope.itemData = {
            		id : $scope.itemInfo.id,
            		pid :$scope.itemInfo.pid
            	};

            	$scope.sdate = $scope.initdate.startDate;
            	$scope.edate = $scope.initdate.endDate;
            	$scope.$on("sdate",function(e,msg){
            		$scope.sdate = msg;
            		$scope.setDateValue();
            	});
            	$scope.$on("edate",function(e,msg){
            		$scope.edate = msg;
            		$scope.setDateValue();
            	});
            	
            	$scope.setDateValue = function(){
            		$scope.itemData.value[0] = $scope.sdate;
            		if($scope.valflag == 2){
            			$scope.itemData.value[1] = $scope.edate;
            		}
            		$scope.sendData();
            	}

                  $scope.valueSelList = [];
                  $scope.keyValList = [];
                  $scope.keyValSelList = [];
                  $scope.attrnull = false;
                  $scope.valnull = false;

                  $scope.initValue = function(){
                        if($scope.showtype == 'string'){
                              $scope.valTxt = "";
                              if($scope.keyValSelList.length>0){
                                    $scope.keyValList = UtilService.cloneJSON($scope.itemData.value);
                                    var isNumber = angular.isNumber($scope.keyValSelList[0]);
                                    $scope.keyValList.filter(function(val){
                                          if(isNumber){
                                                if(!isNaN(Number(val))){
                                                      val = Number(val);
                                                }
                                          }
                                          var kIdx = $scope.keyValSelList.indexOf(val);
                                          if(kIdx == -1){
                                                $scope.valueSelList.unshift(val);
                                                $scope.valueList.push(val);
                                          }else{
                                                $scope.valueList.push($scope.valueSelList[kIdx]);
                                          }
                                    });
                              }
                              else{
                                    $scope.valueList = UtilService.cloneJSON($scope.itemData.value);
                                    $scope.valueList.filter(function(val){
                                          if($scope.valueSelList.indexOf(val) == -1){
                                                $scope.valueSelList.unshift(val);
                                          }
                                    });
                              }
                        }
                        else if($scope.showtype == 'date'){
                              if($scope.itemData.value.length>0){
                                    $scope.sdate = $scope.itemData.value[0];
                                    if($scope.valflag == 2){
                                          $scope.edate = $scope.itemData.value[1];
                                    }
                              }
                              else{
                                    $scope.sdate = $scope.initdate.startDate;
                                    $scope.edate = $scope.initdate.endDate;

                              }
                              $scope.itemData.value = [$scope.sdate,$scope.edate];
                        }
                        else if($scope.showtype == 'number'){
                              if($scope.itemData.value.length>0){
                                    $scope.valTxt1 = $scope.itemData.value[0];
                                    if($scope.valflag == 2){
                                          $scope.valTxt2 = $scope.itemData.value[1];
                                    }
                              }
                              else{
                                    $scope.valTxt1 = "";
                                    $scope.valTxt2 = "";
                              }
                        }
                        if($scope.valueList.length>0){
                              $scope.valStyle = {width:"50px"};
                        }
                  }

            	if(!hasInfo.operator){
            		$scope.operationList = $scope.stringList;
            		$scope.operationinit = $scope.operationList[0].id;
            	}
                  
                  //看单模板匹配
                  if(angular.isDefined($scope.itemInfo.attrMatch)){
                        $scope.profileinitname = $scope.itemInfo.attr;
                        $scope.showtype = $scope.itemInfo.type;
                        if($scope.itemInfo.type == 'string'){
                              $scope.operationList = $scope.stringList;
                        }else{
                              $scope.operationList = $scope.numberList;
                        }
                        $scope.operationinit = $scope.itemInfo.operator;
                        $scope.itemData.value = $scope.itemInfo.value.split(",");
                        $scope.initValue();

                        if(!$scope.infoList || $scope.infoList.length == 0){
                              $scope.attrnull = true;
                        }
                        else{
                              var hs = $scope.infoList.filter(function(itm){
                                    return itm.attr == $scope.itemInfo.attr;
                              });
                              if(hs.length == 0){
                                    $scope.attrnull = true;
                              }
                        }
                  }
                  else{
                       if($scope.itemType == 'profile'){
                              $scope.profileinitname = "请选择用户属性";
                        }
                        else if($scope.itemType == 'event'){
                              $scope.profileinitname = "请选择事件属性";
                        }else{
                              $scope.profileinitname = "请选择";
                        } 
                  }
            	

            	if(hasInfo.attr){
            		$scope.profileinit = hasInfo.attr;
            	}

                  
            	//选择一个属性
                  //属性可能有value，也可能有key,value
                  //如果只有value，往后台直接传递所选value值即可;如果有key，则必须传value对应的key值
                  $scope.changeval = false;
            	$scope.$on("profileid",function(e,msg){
            		$scope.proId = msg.info.attr;

            		$scope.itemData.attr = msg.info.attr;
            		$scope.itemData.type = msg.info.dataType;
                        $scope.showtype = msg.info.webType || msg.info.dataType;

                        $scope.itemData.value = [];
            		$scope.valueList = [];
                        if(msg.info.value){
                              $scope.valueSelList = UtilService.cloneJSON(msg.info.value);
                              $scope.changeval = false;
                        }else{
                              $scope.valueSelList = [];
                              $scope.changeval = true;
                        }
                        if(msg.info.key){
                              $scope.keyValSelList = UtilService.cloneJSON(msg.info.key);
                        }else{
                              $scope.keyValSelList = [];
                        }

            		$scope.attrnull = false;

            		// if(hasInfo.type){
            		// 	$scope.showtype = hasInfo.type;
            		// 	delete hasInfo.type;
            		// }
            		
            		if($scope.showtype == 'string'){
            			$scope.operationList = $scope.stringList;
            		}else{
            			$scope.operationList = $scope.numberList;
            		}

            		if(hasInfo.operator){
	            		$scope.operationinit = hasInfo.operator;
	            		delete hasInfo.operator;
	            	}
	            	else{
				      $scope.operationinit = $scope.operationList[0].id;
	            	}
            		$scope.sendData();
            	});

            	$scope.$on("operationId",function(e,msg){
            		if(msg.info.more){
            			$scope.valflag = 3;
            		}
            		else if(msg.info.both){
            			$scope.valflag = 2;
            		}else{
            			$scope.valflag = 1;
            		}
            		$scope.itemData.operator = msg.info.id;

            		if(hasInfo.value){
            			$scope.itemData.value = hasInfo.value.split(",");
            			 
            			$scope.txtTip = "";
            			delete hasInfo.value;
            		}else{
            			$scope.itemData.value = [];
            			$scope.valueList = [];
                              $scope.keyValList = [];
            		}
            		$scope.valnull = false;
            		$scope.initValue();
            		$scope.sendData();
            	});
            	
            	$scope.valueList = [];
            	$scope.txtTip = "请输入一个属性过滤条件";

                  $scope.getValueList = function(){
                        if($scope.changeval && $scope.proId && $scope.itemType == 'event'){
                              var url = $scope.common?"/event/find/value/attr":"/event/find/value/one";
                              var param = $scope.common?{attrName:$scope.proId}:{eventname:$scope.itemEvent,attrname:$scope.proId}
                              var valPM = HttpService.getInfo($rootScope.appid+url,param);
                              valPM.then(function(data){
                                    if(data.key && data.key!=null){
                                          $scope.keyValSelList = data.key;
                                    }
                                    else{
                                          $scope.keyValSelList = [];
                                    }
                                    if(data.value && data.value!=null){
                                          $scope.valueSelList = data.value;
                                    }
                                    else{
                                          $scope.valueSelList = [];
                                    }
                                    $scope.changeval = false;
                              });
                        }
                  }
            	$scope.setValue = function(val){
            		$scope.valnull = false;
            		if(!val || val==''){return false;}

            		var idx = $scope.valueList.indexOf(val);
            		if(idx>-1){
            			// $scope.valueList.splice(idx,1);
            		}
            		else
            		{
            			if($scope.valflag == 3){
            				$scope.valueList.push(val);
            			}
            			else{
            				$scope.valueList = [val];
            			}
                              if($scope.keyValSelList.length>0){
                                    var kIdx = $scope.valueSelList.indexOf(val),kv = $scope.keyValSelList[kIdx];
                                    if(!kv){
                                          kv = val;
                                    }
                                    if($scope.valflag == 3){
                                          $scope.keyValList.push(kv);
                                    }
                                    else{
                                          $scope.keyValList = [kv];   
                                    }
                                    if(kIdx == -1){
                                          $scope.keyValSelList.push(kv);
                                          $scope.valueSelList.push(val);
                                    }
                                   
                                    $scope.writeValue(kv);
                                    $scope.itemData.value = UtilService.cloneJSON($scope.keyValList);
                              }
                              else{
                                  $scope.itemData.value = UtilService.cloneJSON($scope.valueList); 

                                  var kIdx = $scope.valueSelList.indexOf(val);
                                  if(kIdx==-1){
                                     $scope.valueSelList.push(val);
                                  }
                                 
                              }
                              
            			
            			$scope.sendData();
            		}
            		

            		$scope.showsel = false;
            		$scope.valTxt = "";
            		$scope.txtTip = "";


                        $(el).find("#valTxt").focus();
            	}
            	$scope.removeValue = function(idx){
            		$scope.valueList.splice(idx,1);
                        if($scope.keyValList.length>0){
                              $scope.keyValList.splice(idx,1);
                              $scope.itemData.value = $scope.keyValList;
                        }
                        else{
                              $scope.itemData.value = $scope.valueList;
                        }
            		
            		if($scope.valueList.length == 0){
            			$scope.txtTip = "请输入一个属性过滤条件";
                              $scope.valStyle = {};
            		}
            		$scope.sendData();
            	}
                  $scope.writeValue = function(v){ 
                        $scope.showsel = true;
                        if($scope.valueList.length == 0){
                              $scope.txtTip = "请输入一个属性过滤条件";
                              $scope.valStyle = {};
                              return;
                        }
                        var w = (v+"").length * 8;
                        w = w < 50 ? 50 : w;
                        w = w > 120 ? 120 : w;
                        $scope.valStyle = {width:w+"px"};
                  }
            	$scope.setNumberVal = function(){
            		$scope.itemData.value[0] = $scope.valTxt1;
            		if($scope.valflag == 2){
            			$scope.itemData.value[1] = $scope.valTxt2;
            		}
            		$scope.sendData();
            	}
            	//向上or向下加减数字
            	$scope.addNumber = function(flag,m){
            		$scope.valnull = false;
            		if(flag == 1){
            			if(!$scope.valTxt1 || $scope.valTxt1 == ''){
            				$scope.valTxt1 = 0;
            			}
            			$scope.valTxt1 = Number($scope.valTxt1);
            			$scope.valTxt1 += m;
            			$scope.valTxt1 = $scope.valTxt1 < 0 ? 0 : $scope.valTxt1;
            			$scope.itemData.value[0] = $scope.valTxt1;
            		}
            		if(flag == 2){
            			$scope.valTxt2 = Number($scope.valTxt2);
            			if(!$scope.valTxt2 || $scope.valTxt2 == ''){
            				$scope.valTxt2 = 0;
            			}
            			$scope.valTxt2 += m;
            			$scope.valTxt2 = $scope.valTxt2 < 0 ? 0 : $scope.valTxt2;
            			$scope.itemData.value[1] = $scope.valTxt2;
            		}
            		$scope.sendData();
            	}
            	$scope.sendData = function(){
            		// console.log($scope.itemData)
            		$scope.$emit($scope.itemType,$scope.itemData);
            	}

            	
            	$scope.$on($scope.itemData.id,function(){
            		if(UtilService.isNullStr($scope.itemData.attr)){
            			$scope.attrnull = true;
            		}
            		if(UtilService.isNullStr($scope.itemData.value) || $scope.itemData.value.length == 0){
            			$scope.valnull = true;
            		}else if($scope.valflag == 2 && ($scope.valTxt1=='' || $scope.valTxt2=='')){
            			$scope.valnull = true;
            		}
            	});
            }
        }
	}
})();