(function(){
	var tempVersion = new Date().getTime();
	
	angular.module("app")
	.filter("charfilter",charfilter)
	.filter("filterList",filterList)
	.filter("filterPay",filterPay)
	.filter("numFixed",["UtilService",numFixed])
	.filter("filterHtml",["$sce",filterHtml])
	.filter("formatRate",["UtilService",formatRate]);

	//渠道首字母过滤
	function charfilter(){
		return function(input, param) {
	      if(param == ""){
	         return input;
	      }else{
	          var output = [];  
	          angular.forEach(input, function(v,k){  
	               if (param.indexOf(v.firstchar)>-1) {  
	                    output.push(v);  
	               }  
	          });  
	          return output; 
	      }
	   };  
	}

	//列表多个属性过滤 
	function filterList(){
		return function(input,v, param) {
	      if(!v || v == ""){
	         return input;
	      }else{
	          	var paramkeys = param.split(",");
	          	return input.filter(function(item){
	          		var has = false;
	          	  	for(var i = paramkeys.length-1;i>=0;i--){
	          	  		if(item[paramkeys[i]] && angular.uppercase(String(item[paramkeys[i]])).indexOf(angular.uppercase(v))>-1){
	          	  			has = true;
	          	  			break;
	          	  		}
	          	  	}
	          	  	return has;
	          	});
	      }
	   };  
	}

	function filterPay(){
		return function(input){
			if(input < 10000){
				return input;
			}
			else{
				return (input/10000).toFixed(1) +"w";
			}
		}
	}
	function filterHtml($sce){
		return function (text) {
            if(text == null){
                return "";
            }else{
                return $sce.trustAsHtml(text);
            }
        };
	}

	function numFixed(UtilService){
		return function(num,params){
			if(num == null || num =='null'){return 0;}
			params = params ? params : 2;
			if(isNaN(Number(num))){
				return num;
			}else{
				return UtilService.decimal2(Number(num),params);
			}
		}
	}

	function formatRate(UtilService){
		return function(num,rate,formatjson,rate1){
			if(num == null || num =='null' || !rate || !formatjson){return num;}
			if(isNaN(Number(num))){
				if(num.indexOf("_")==0){num = num.substring(1);}
				return num;
			}
			if(rate1){rate = rate1;}

			var format = formatjson[rate];
			if(!format){format = 'float';}

			if(format == 'percent'){
				return UtilService.decimal2(Number(num)*100,2) + "%";
			}
			else if(format == 'float'){
				return UtilService.decimal2(Number(num),2);
			}
			else if(format == 'int'){
				return Math.round(Number(num));
			}
			else{
				return num;
			}
		}

	}
})();