
Date.getFirstDay = function(date){
	return new Date(date.getFullYear(),date.getMonth(),1);
};

Date.isSameDay = function(d1, d2){
	return d1 && d2 && (d1.getFullYear() === d2.getFullYear()) && (d1.getMonth() === d2.getMonth()) && (d1.getDate() === d2.getDate());
}

Date.prototype.isSameDay = function(date) {
	return Date.isSameDay(this,date);
};
Date.prototype.yestDay = function(){
	this.setDate(this.getDate()-1);
	var d = this.toLocaleDateString();
	var YY = this.getFullYear(),
        MM = this.getMonth() + 1,
        DD = this.getDate();
    if (MM < 10) MM = "0" + MM;
    if (DD < 10) DD = "0" + DD;
    return YY + "-" + MM + "-" + DD
}
Date.prototype.Format = function (fmt) { //author: meizz 
    var o = {
        "M+": this.getMonth() + 1, //月份 
        "d+": this.getDate(), //日 
        "h+": this.getHours(), //小时 
        "m+": this.getMinutes(), //分 
        "s+": this.getSeconds(), //秒 
        "q+": Math.floor((this.getMonth() + 3) / 3), //季度 
        "S": this.getMilliseconds() //毫秒 
    };
    if (/(y+)/.test(fmt)) fmt = fmt.replace(RegExp.$1, (this.getFullYear() + "").substr(4 - RegExp.$1.length));
    for (var k in o)
    if (new RegExp("(" + k + ")").test(fmt)) fmt = fmt.replace(RegExp.$1, (RegExp.$1.length == 1) ? (o[k]) : (("00" + o[k]).substr(("" + o[k]).length)));
    return fmt;
}
Date.prototype.rangeDate = function(endDate){
	var dates = [];
	dates.push(this.Format("yyyy-MM-dd"));
	if(!this.isSameDay(endDate)){
		this.setDate(this.getDate()+1);
		while(!this.isSameDay(endDate)){
			dates.push(this.Format("yyyy-MM-dd"));
			this.setDate(this.getDate()+1);
		}
		dates.push(endDate.Format("yyyy-MM-dd"));
	}
	return dates;
}
function rangeDate(sDate,eDate){
	return new Date(sDate).rangeDate(new Date(eDate));
}

function diffDate(sDate,eDate){
	return (new Date(eDate) - new Date(sDate))/(24*3600*1000) + 1;
}

function addDate(date,days){
	var d = new Date(date);
	d.setDate(d.getDate()+days); 
	return d.Format("yyyy-MM-dd");
}

function getNowWeek(){
	var today = Date.today();
	var firstDay = new Date(today.getFullYear(), 0, 1),fw = firstDay.getDay();
	var endDay = firstDay.clone(),n = 0;
	if( fw > 0){
		endDay = endDay.addDays(8-fw);
		n = 1;
	}
	var days = diffDate(endDay , today);
	return Math.ceil(days/7) + n;
}