(function(){
     angular.module("app.login")
        .controller("registerCtrl",["$scope","UtilService","$http","$interval",registerCtrl]);

    function registerCtrl($scope,UtilService,$http,$interval){
        TrackingIO.init(UtilService.getTKAppkey());

        //loading加载
        $scope.showLoading = function(){
            document.getElementById("sysLoad").style.display = "block";
        }
        $scope.hideLoading = function(){
            document.getElementById("sysLoad").style.display = "none";
        }
        $http.get("/data/channel.json").success(function(data){
            $scope.channelNames = data;
        })
        $scope.hasReged = false;
        $scope.save = function(){
            var par = {
                email: $scope.email,
                password: $scope.password,
                company: $scope.company,
                name: $scope.username,
                phone: $scope.phone,
                wechat: $scope.wechat,
                qq: $scope.qq
            };
            var verPar = {
                email: {
                    key: 'email',
                    max:48,
                    val: par.email,
                    txt:"邮箱最长48位"
                },
                password: {
                    key: 'pwd',
                    val: par.password
                },
                crmpwd: {
                    key: 'pwd',
                    val: $scope.crmpwd
                },
                company: {
                    key: 'companyname',
                    max:96,
                    val: $scope.company
                },
                username: {
                    key: 'username',
                    max:32,
                    val: $scope.username
                },
                phone: {
                    key: 'cellphone',
                    val: $scope.phone
                },
                wechat: {
                    key: 'wechat',
                    val: $scope.wechat
                },
                qq: {
                    key: 'qq',
                    val: $scope.qq
                }
            }
            var reg = /^([a-zA-Z0-9]+[_|\_|\.|\-]?)*[a-zA-Z0-9]+@([a-zA-Z0-9]+[_|\_|\.|\-]?)*[a-zA-Z0-9]+\.[a-zA-Z]{1,63}$/;
            $scope.tip = formJudge(verPar);
            if($scope.email == undefined){
                if ($scope.tip.succ == true) {
                    $scope.tip.succ = false;
                }
                $scope.tip.email = {
                    status:true,
                    txt:"必填"
                }
            }
            if($scope.email != undefined && !reg.test($scope.email)){
                if ($scope.tip.succ == true) {
                    $scope.tip.succ = false;
                }
                $scope.tip.email = {
                    status:true,
                    txt:"请输入正确的邮箱格式"
                }
            }
            if($scope.password != $scope.crmpwd){
                if ($scope.tip.succ == true) {
                    $scope.tip.succ = false;
                }
                $scope.tip.crmpwd = {
                    status:true,
                    txt:"两次密码不一致，请重新输入"
                }
            }
            if ($scope.tip.succ != true) {
                return false;
            }

            $scope.par = par;
            var emailsub = par.email.substring(par.email.indexOf("@")+1,par.email.lastIndexOf("."));
            if($scope.channelNames && ($scope.channelNames.emails.indexOf(angular.lowercase(emailsub)) > -1 || $scope.channelNames.companys.indexOf(angular.lowercase(par.company)) > -1 || $scope.channelNames.companys.indexOf(angular.lowercase(par.name)) > -1)){
                $scope.channelText = true;
            }else{
                $scope.channelText = false;
                $scope.postSave();
            }
        }

        $scope.postSave =function(){
            $scope.channelText = false;
            $scope.errorMessage = "";
            $scope.showLoading();
            $http.post("api/reged/regedaccount",$scope.par).success(function(data){
                $scope.hideLoading();
                if(data.code == -1){
                    $scope.tip.email = {
                        status:true,
                        txt:"该邮箱已注册"
                    }
                    //$scope.errorMessage = "该邮箱已注册";
                }
                else if(data.code == 201){
                    $scope.errorMessage = "注册失败";
                }
                else if(data.code == 250){
                    $scope.errorMessage = "邮件发送失败，请重新注册";
                }else{
                    TrackingIO.register($scope.email);

                    UtilService.setCookie("regId",data.content.id,7);
                    UtilService.setCookie("regEmail",$scope.email,7);
                    UtilService.setCookie("regFlag",0,7);
                    UtilService.setCookie("ryioAcvitation",0,7);
                    
                    window.location.href = "activation.html";
                }
            });
        }
        $scope.keyEvt= function(e){
            if(e.keyCode == 13){
                $scope.save();
            }
        }
        $scope.closeWin = function(){
            $scope.channelText = false;
        }
    }
})();
