(function(){
     angular.module("app.login")
        .controller("resetpwdCtrl",["$scope","UtilService","$http","$interval","$location",resetpwdCtrl]);

    function resetpwdCtrl($scope,UtilService,$http,$interval,$location){
    	//loading加载
        $scope.showLoading = function(){
            document.getElementById("sysLoad").style.display = "block";
        }
        $scope.hideLoading = function(){
            document.getElementById("sysLoad").style.display = "none";
        }
        $scope.forgetMessage = $location.search().message;
        $scope.forgetToken = $scope.forgetMessage.substring(0,32);
        $scope.forgetId = $scope.forgetMessage.substring(32,100);

        $http.get("api/reged/validatepass?message="+$scope.forgetMessage).success(function(data){
            if(data.content=="success"){
                $scope.resetTpye = "yes";
            }else{
                $scope.resetTpye = "no";
            }
        });
        $http.get("api/reged/find/"+$scope.forgetId).success(function(data){
            $scope.registerEmail = data.content.email;
            $scope.isShowSend = !data.content.isSuperUser && data.content.status != 1;
        });
        $scope.sendEmail = function(){
            $scope.showLoading();
            $http.get("/api/reged/sendforgetpwdemail?email="+$scope.registerEmail).success(function(data){
                $scope.hideLoading();
                if(data.content.message == "账号不存在"){
                    $scope.tip = {
                        send:{
                            status:true,
                            txt:"邮箱未注册过账号"
                        }
                    };
                }else if(data.content.message == "success"){
                    $scope.resetTpye = "send";
                }else{
                    $scope.tip = {
                        send:{
                            status:true,
                            txt:"邮件发送失败"
                        }
                    };
                }
            });
        }
        $scope.loginEmail = function(){
            var mail = $scope.registerEmail.split("@");
            window.open("http://mail."+mail[1]);
        }

        $scope.hasReged = true;
    	$scope.save = function(){
            var par = {
                token: $scope.forgetToken,
                newpwd : $scope.newpwd
            };
            var verPar = {
                newpwd: {
                    key: 'pwd',
                    val: par.newpwd
                },
                crmpwd: {
                    key: 'pwd',
                    val: $scope.crmpwd
                }
            }
            $scope.tip = formJudge(verPar);
            if ($scope.tip.succ != true) {
                return false;
            }
            if($scope.newpwd != $scope.crmpwd){
                $scope.tip = {
                    crmpwd:{
                        status:true,
                        txt:"两次密码不一致，请重新输入"
                    }
                }
                return false;
            }
            $scope.errorMessage = "";
            $scope.showLoading();
            $http.post("api/reged/updatepwd/"+$scope.forgetId,par).success(function(data){
                $scope.hideLoading();
                if(data.content == "invalid request"){
                    $scope.tip = {
                        newpwd:{
                            status:true,
                            txt:"非法链接"
                        }
                    };
                }else if(data.content == "update success"){
                    window.location.href = "login.html";
                }else if(data.content == "out of date or repeat Upwd request"){
                    $scope.tip = {
                        newpwd:{
                            status:true,
                            txt:"链接已失效"
                        }
                    };
                }else if(data.content == "密码不能修改"){
                    $scope.tip = {
                        newpwd:{
                            status:true,
                            txt:"该账号密码不可修改"
                        }
                    };
                }else{
                    $scope.tip = {
                        newpwd:{
                            status:true,
                            txt:"修改密码失败"
                        }
                    };
                }
            });
        }
        $scope.keyEvt= function(e){
            if(e.keyCode == 13){
                $scope.save();
            }
        }    
          
    }
})();