(function(){
    angular.module("app.manage")
        .controller("activityeventCtrl",["$rootScope","$scope","HttpService","ToolService","UtilService","$state","$timeout","$stateParams",activityeventCtrl])
        .controller("activityeventDetailCtrl",["$scope","$rootScope","HttpService","ToolService","UtilService","$q","$state","$stateParams","$timeout",activityeventDetailCtrl]);

    function activityeventCtrl($rootScope,$scope,HttpService,ToolService,UtilService,$state,$timeout,$stateParams){
        $scope.query = function(){
            var eventPM = HttpService.getInfo("mng/virtual/find/"+$scope.appid);
            ToolService.showLoading();
            eventPM.then(function(data){
                ToolService.hideLoading();
                $scope.eventList = data;
            });
        }
        $scope.$watch("appid",function(n){
            if(angular.isDefined(n)){
                $scope.query();
            }
        });

        $scope.$on('flipinfo',function(e,msg){
            $scope.flipPage = msg;          
        });

        $scope.onUser = function(id){
            ToolService.showLoading();
            var userPM = HttpService.putInfo("mng/virtual/find/"+id+"/enable");
            userPM.then(function(data){
                ToolService.hideLoading();
                ToolService.showTips("启用成功")
                $scope.query();
            });
        }
        $scope.offUser = function(id){
            var userPM = HttpService.putInfo("mng/virtual/find/"+id+"/disable");
            ToolService.showLoading();
            userPM.then(function(data){
                ToolService.hideLoading();
                ToolService.showTips("停用成功")
                $scope.query();
            });
        }

        $scope.gopage = function(info){
            if(angular.isDefined(info)){
                $state.go("collect.activityeventDetail",{aid:info});
            }else{
                $state.go("collect.activityeventDetail");
            }
        }
    }

    function activityeventDetailCtrl($scope,$rootScope,HttpService,ToolService,UtilService,$q,$state,$stateParams,$timeout){
        var editInfo = $stateParams.aid;
        $scope.title = editInfo?"编辑虚拟事件":"新建虚拟事件";
        $scope.inputdis = false;
        if(editInfo == null){ //新建虚拟事件
            editInfo = {eventList:[],type:'userdefine'};
            $scope.specialEvents = [];
             $scope.name = "";
        }
        else{
            $scope.name = editInfo.ch_name;
            if(editInfo.type == 'userdefine'){ //虚拟事件
                $scope.specialEvents = [];
            }
            else{//活跃事件
                $scope.inputdis = true;
                if($scope.isweb){
                    $scope.specialEvents = ["pageview"];
                }
                else{
                    $scope.specialEvents = ["loggedin","reged","payment"];
                }
            }
        }
        

        var listId = editInfo.id;
        var chooseStr = editInfo.eventList;
        $scope.$watch("appid",function(n){
            if(angular.isDefined(n)){
                $scope.query();
            }
        });

        /*var noFalse = [];
        $scope.eventList.filter(function(item){
            if(item.status == true){
                noFalse.push(item);
            }
        });*/

        $scope.query = function(){
            var url = "";
            if(editInfo!=null && editInfo.type != 'userdefine'){
                url = "mng/virtual/unselect/"+$scope.appid;
            }
            else{
                url = "mng/event/find/"+$scope.appid;
            }
            var eventPM = HttpService.getInfo(url);
            ToolService.showLoading();
            eventPM.then(function(data){
                ToolService.hideLoading();

                $scope.eventList = data.filter(function(item){
                    if(item.status == true){
                        if(chooseStr.indexOf(item.eventName) > -1 || $scope.specialEvents.indexOf(item.eventName)>-1){
                            item.ischeck = true;
                        }
                        else{
                            item.ischeck = false;
                        }
                    }
                    return item.status == true;
                });
            });
        }
        

        var chooseNum = 0,max = 5;
        $scope.chooseItem = function(info){
            chooseNum = 0;
            for(var i = 0; i < $scope.eventList.length; i++){
                if($scope.eventList[i].ischeck == true){
                    chooseNum = chooseNum + 1;
                }
            }
            if(chooseNum < max){
                info.ischeck = true;
            }
            else{
                ToolService.showTips("最多可以选择"+max+"个");
            }
            
        }
        $scope.cancelItem = function(info){
            if($scope.specialEvents.indexOf(info.eventName)>-1){
                info.ischeck = true;
            }else{
                info.ischeck = false;
            }
        }
        $scope.selectAllEvent = function(){
            if($scope.eventList.length > max){
                ToolService.showTips("最多可以选择"+max+"个");
            }
            else{
                $scope.selAll = !$scope.selAll;
                $scope.eventList.filter(function(item){
                    if($scope.specialEvents.indexOf(item.eventName)>-1){
                        item.ischeck = true;
                    }else{
                        item.ischeck = $scope.selAll;
                    }
                });
            }
        }

        $scope.save = function(){
            var chooseList = [];
            for(var i = 0; i < $scope.eventList.length; i++){
                if($scope.eventList[i].ischeck == true){
                    chooseList.push($scope.eventList[i].eventName);
                }
            }
            var params = {
                ch_name : $scope.name,
                eventList : chooseList.join(",")
            };

            $scope.tip = {},error = false;
            var verPar = {
                name: {
                    key: 'spcname2',
                    val: params.ch_name,
                    txt: "含非法字符或过长（支持输入汉字、大小写字母、数字、下划线，长度限制40字符以内）"
                }
            };
            $scope.tip = formJudge(verPar);
            if($scope.tip.succ != true) { 
                error = true;
            }
                
            if(chooseList.length<2){
                $scope.tip.moreparams = {
                    status:true,
                    txt:'请至少选择2个事件'
                }
                return false;
            }
            if(error){return false;}

            var savePM = null,txt = "保存成功";
            if(listId){
                params.id = listId;
                params.type = editInfo.type;
                savePM = HttpService.putInfo("mng/virtual/update/"+$scope.appid,params);
            }
            else{
                txt = "新建成功";
                savePM = HttpService.postInfo("mng/virtual/userdefined/"+$scope.appid,params);
            }
            ToolService.showLoading();
            savePM.then(function(data){
                ToolService.hideLoading();
                if(data.code == -6001){
                    $scope.tip.name = {
                        status:true,
                        txt:'名称重复'
                    }
                    ToolService.showTips("名称重复");
                }
                else{
                    $scope.cancel();
                    ToolService.showTips(txt);
                }
            },function(data){
                ToolService.hideLoading();
                if(data.code == -6001){
                    $scope.tip.name = {
                        status:true,
                        txt:'名称重复'
                    }
                    ToolService.showTips("名称重复");
                }
            });
        }

        $scope.cancel = function(){
            $state.go("collect.activityevent");
        }
    }
})();
        